# A brief history of Pawn

For recent version history, see the [Pawn readme](Readme.md).

### Version 2.12.1

* Mists of Pandaria Classic: Fixed a problem where only cloth and leather classes playing in German would see mail armor as potential upgrades.
* Fixed a minor problem where German items for which you haven't yet collected the transmog appearance would appear on Pawn's Compare tab as having a "special effect."

### Version 2.12.0

* Midnight: Pawn can now be used on the Midnight beta.
* Midnight: Added support for Devourer Demon Hunters. (Devourer stat weights are currently placeholders.)
* Removed a workaround for a bug in Shadowlands 9.1.5 bug that was fixed in later WoW versions. (Hopefully this will also stop occasional errors when using Pawn with addons that reskin tooltips.)
* Added a feature that allows custom tooltip addon authors to integrate with Pawn's "color tooltip border of upgrades" feature.

### Version 2.11.9

* The War Within: When inspecting another player, the Pawn button will now appear in the lower-left corner of the character sheet even if it's normally set to display in the lower-right (the default), since there's now a Talents button occupying that space.
* Classic versions: When hovering over the Pawn button on your character sheet, you'll now see the average item level of your gear like you do when hovering over the Pawn button when inspecting another character.

### Version 2.11.8

* Mists of Pandaria Classic: Added an experimental fix for a bug in the game that was causing strange quest upgrade suggestions. (You'll see a few things spammed to your chat log if you encounter the bug—I'd appreciate it if you could let me know what it says.)

### Version 2.11.7

* Classic Era: Fixed a bug introduced in version 2.11.6 that caused an error message when playing a druid on Classic Era realms and for the names of the druid starter scales to show up incorrectly.

### Version 2.11.6

* Mists of Pandaria Classic: Fixed a bug that could cause Pawn to show the wrong spec on a fresh character (either Blood or none at all).
* Mists of Pandaria Classic: Added spec icons to tooltips and the Pawn UI in Automatic mode, like on The War Within.
* Mists of Pandaria Classic: Added support for more items with critical strike when playing in Latin American Spanish.

### Version 2.11.5

* Classic Era: Fixed an error that would occur when using wands with arcane damage when playing in Traditional Chinese on Classic Era realms.

### Version 2.11.4

* Fixed a bug where turning off Pawn's socketing advisor was even less effective than Basic Campfire.
* Mists of Pandaria Classic: Fixed a bug where Pawn's reforging advisor couldn't be turned off.

### Version 2.11.3

* Mists of Pandaria Classic: Added support for rare French items with spell power (Le bâton des Mondes jumeaux).
* Fixed a harmless bug where when playing Mists of Pandaria Classic in French and using the Compare tab with one or more items you haven't collected the appearance of, those items would show up as having les effets spéciaux.

### Version 2.11.2

* Mists of Pandaria Classic: Fixed a bug where some items with Expertise stopped working properly after patch 5.5.
* Fixed a problem where an error in LinkWrangler could then also cause Pawn to fail if you used both addons.

### Version 2.11.1

* Mists of Pandaria Classic: Fixed a bug where some items with Hit and Haste stopped working properly in some languages after patch 5.5.
* Mists of Pandaria Classic: Fixed a problem where Pawn would display an error when logging in when playing in Russian and European Spanish.

### Version 2.11.0

* Mists of Pandaria Classic: Pawn now works on Mists of Pandaria Classic and patch 5.5.
* Mists of Pandaria Classic: Pawn's Automatic mode is now available. Automatic mode will be turned on the first time each character logs in after Mists of Pandaria Classic, but you can turn it off at any time after that.
* Mists of Pandaria Classic: Pawn's original Wowhead starter scales from patch 5.4 have been added. Note that these are more than ten years old and may not reflect the latest simulations; you can get more accurate results if you import stat weights obtained by simulating your character and gear in other tools.

### Version 2.10.14

* The War Within and Cataclysm Classic: Pawn will no longer incorrectly assume that arms warriors can dual-wield.
* Cataclysm Classic: Fixed a bug in the default Cataclysm stat weights that was causing item scores for one-handed weapons to usually be much higher than scores for two-handed weapons.
* Fixed a bug on the Weights tab where the "These items are unusable" option would show up as "Items with this are unusable."

### Version 2.10.13

* Classic Season of Discovery: Items with haste (casting speed) are supported again after patch 1.15.7.
* Classic Season of Discovery: Fixed a bug that prevented combined melee and spell crit percentage from being recognized on items when playing in Brazilian Portuguese.
* Classic Season of Discovery: Fixed a bug that prevented spell damage and healing from being recognized on items when playing in Traditional Chinese.

### Version 2.10.12

* The War Within: Pawn is now compatible with WoW 11.1.5 and custom item quality colors.

### Version 2.10.11

* Cataclysm Classic: Added support for the new way that weapon stats appear in the French version of the game.
* Cataclysm Classic: Fixed a minor bug where Rigid Zircon was being suggested as a yellow gem even though it's blue.

### Version 2.10.10

* Classic Season of Discovery: Added support for the new expertise (chance for your attacks to be dodged or parried), haste (attack speed), and spell haste (casting speed of non-channeled spells) stats in all languages SoD supports.

### Version 2.10.9

* Includes more changes to old code to help avoid hard-to-debug problems in the future.

### Version 2.10.8

* Cataclysm Classic: Haste should work on more items when playing in Russian. (Thanks DrCrazy!)

### Version 2.10.7

* The War Within: Other rings will no longer appear as upgrades to Cyrce's Circlet. (Previously, pretty much everything would, since its only stat is Stamina.)
* Includes a bunch of changes to some old code provided by DrCrazy that should make it easier to edit Pawn. (Thanks!) This shouldn't affect the way the addon functions. Hopefully.

### Version 2.10.6

* Cataclysm Classic: Slightly updated stat weights for retribution paladins.

### Version 2.10.5

* The War Within: Fixed a problem where Pawn would only work if "load out of date addons" was checked.
* Cataclysm Classic: Updated stat weights for unholy death knights, feral druids, arcane mages, and retribution paladins.

### Version 2.10.4

* Cataclysm Classic: Mastery on items should work again when playing in Russian. (Thanks DrCrazy!)

### Version 2.10.3

* Updated default stat weights for all specs in The War Within and several specs in Cataclysm Classic.

### Version 2.10.2

* The War Within: Adjusted gem recommendations for 80 gear. (Previously, socketed Khaz Algar items were being valued too highly.)
* Cataclysm Classic: Updated default stat weights for several specs.

### Version 2.10.1

* Cataclysm Classic: Updated default stat weights for fury warriors, and further reduced the value of armor for specs that don't traditionally need much of it.
* Updated translations for Simplified Chinese. (Thanks LvWind!)

### Version 2.10.0

* The War Within: Added support for the new Khaz Algar gems.
* The War Within: You can now open the Pawn window from the addons icon in the upper-right corner of the screen, even if you've hidden the Pawn button from your character sheet on Pawn's Options tab.
* Pawn's window now features some oranger The War Within-inspired visuals.

### Version 2.9.14

* The War Within pre-patch: Pawn will once again show up in the game's Interface Options.
* Cataclysm Classic: Updated default stat weights for fire mages, enhancement shamans, and fury warriors.
* All Classic versions: Fixed a problem where relic slot items (idols, totems, and librams) could appear as an upgrade for classes that can't use them and could not be ignored.

### Version 2.9.13

* Cataclysm Classic: Updated the default stat weights for almost all classes and specs.

### Version 2.9.12

* Cataclysm Classic: Fixed a problem where one-handed weapons that can be wielded in either hand were being undervalued for all melee classes if you used the default stat weights.

### Version 2.9.11

* Cataclysm Classic: More updates to correctly read numbers larger than 999 on items when playing in French.

### Version 2.9.10

* Cataclysm Classic: Fixed a problem where the default stat weights for expertise were incorrect for all classes and specs.

### Version 2.9.9

* Cataclysm Classic: Fixed a problem where certain items with mastery and certain haste enchantments had those stats ignored when playing in Russian, European Spanish, and Latin American Spanish.
* You can now click an item link in chat and then Alt+LeftClick the popup that appears to get a window that lets you copy all of the text on that item to the clipboard. (This is mostly only useful to me when I need to type Искусность but my keyboard doesn't have those letters.) Previously this feature only worked on Pawn's Compare tab.

### Version 2.9.8

* Fixed a problem introduced in Pawn 2.9.7 that caused the "Show icons next to tooltips" feature to cause an error. (Actually, Ulidan did. Thanks Ulidan and Kraturnus!)
* Cataclysm Classic: Ranged Attack Power no longer appears as a distinct stat you can give a weight to; just use Attack Power for both melee and ranged.
* Cataclysm Classic: Updated the default stat weights for retribution paladins.

### Version 2.9.7

* The War Within: Pawn now works on The War Within beta and WoW 11.0.
* Mists of Pandaria Remix: Fixed another case where the socketing advisor could appear and give dubious advice.

### Version 2.9.6

* Mists of Pandaria Remix: Pawn's socketing advisor is now disabled in this mode, since gems work differently.
* Cataclysm Classic: Updated default stat weights for all specs and classes are included, thanks to the [WoWSims](https://wowsims.github.io) team. Simulations are still in their early stages, so expect some oddities—let me know if you find something egregiously wrong. Simulating your character with WoWSims (or any other favorite sim) will get you the most accurate results, and you can export custom stat weights to use in Pawn for quick in-game advice.
* Cataclysm Classic: You can now set a weight for the non-stat effect of meta gems like you could in Burning Crusade Classic and Wrath Classic.
* Cataclysm Classic: The deprecated stats Defense Rating and Block Value will no longer show up in Pawn.
* Classic Era and Season of Discovery: Fixed a harmless error message about gem data.

### Version 2.9.5

* Fixed some problems introduced in Pawn 2.9.4 where Pawn could give you an error when socketing an item.
* Cataclysm Classic: Added support for the armor specialization skills such as Mail Specialization.

### Version 2.9.4

* Cataclysm Classic: Cogwheel sockets on engineering goggles will now be considered in the item's value like any other gem socket.
* Cataclysm Classic: Fixed a bug that caused gems with bad secondary stats to be valued more highly than they should have been (it was calculating things as if you could reforge the gem's bad stat into something better). The bug shouldn't have affected the values of existing items unless you were using gems that are bad for your spec.

### Version 2.9.3

* Cataclysm Classic: Fixed a problem where the "track for each scale (advanced)" option could cause an error.
* Cataclysm Classic: Pawn will no longer display a warning when logging in if you play in French.

### Version 2.9.2

* Cataclysm Classic: When visiting an Arcane Reforger, Pawn will now display advice on how to reforge the item to maximize its power. (You can turn this off with the "show reforge advisor" option.)
* Cataclysm Classic: Pawn's Compare tab will now show you how much an item's score can be improved by reforging it (assuming you make the change that Pawn suggests).
* Cataclysm Classic: Pawn will now take reforging into account when determining an item's score and whether or not it's an upgrade.

### Version 2.9.1

* Cataclysm Classic: Pawn will now recommend the proper gems based on the new colors and stats of existing gems.
* Cataclysm Classic: Fixed a bug that caused a few stat weights to get reset to 0 when editing in the Weights tab and then reloading.
* Cataclysm Classic: Added support for all of the new Cataclysm gems, which Pawn will start recommending as you get Cataclysm gear.
* Fixed a bug that caused gems to always appear as upgrades.

### Version 2.9.0

* Cataclysm Classic: Added basic support for Cataclysm Classic. The following important work is _not_ yet done:
    * Updated stat weights (if you know of a good source, please let me know!)
    * Reforging support
    * I'm not playing Classic, so I'll need your help pointing out remaining things that are broken!

### Version 2.8.11

* Classic Season of Discovery: Added support for those new hit and crit stats, again. Because Blizzard broke them in a patch.

### Version 2.8.10

* Classic Season of Discovery: Added support for the new Gnomeregan items with hit or crit to all attacks. Items with the new hit stat will receive points for your Hit and Hit (Spell) stats, and items with the new crit stat will receive points for your Crit and Crit (Spell) stats.

### Version 2.8.9

* Dragonflight: Updated stat weights for all classes and specs.
* Dragonflight: Updated Pawn's scale color button to work with the new patch 10.2.5 color picker.

### Version 2.8.8

* Dragonflight: Removed the "Only show upgrades for my best armor type after level 27" option. After level 27, Pawn will now always stop showing items that are not the right type of armor for your class.
* Classic: Fixed a bug where Pawn would suggest armor your character can't wear as upgrades.
* Classic: Fixed a bug where Pawn would sometimes suggest socketing Glinting Flame Spessarite when it meant to suggest Sovereign Shadow Draenite. This bug potentially affected any time Glinting Flame Spessarite was suggested (such as in the socketing advisor popup), but didn't affect any other calculations or upgrade suggestions.

### Version 2.8.7

* Classic: Added support for the Classic trade skill and crafting window: hovering over the item icon in that window should now work the same as if the item were already in your bags.

### Version 2.8.6

* Dragonflight: More new stat weight updates, updated for patch 10.2.0.

### Version 2.8.5

* Dragonflight: New stat weights have been included for all classes and specs, including all evoker specs, based on the latest Ask Mr. Robot raid simulation data.

### Version 2.8.4

* To keep things responsive, especially on the slower Classic versions of the game, Pawn has a new system that caps how much processing power it will allow bag addons to use when calculating which items get green upgrade arrows. Roughly speaking, if the game runs at 60 FPS for you, Pawn will block bag addons from reducing that by more than 2 FPS. (This change doesn't affect you if you aren't using a custom bag addon.)

### Version 2.8.3

* Wrath Classic: The new gems for Content Phase 3 (Cardinal Ruby, etc.) will now show up in recommendations, and will be taken into account when determining the value of sockets on high-level gear.

### Version 2.8.2

* Dragonflight: Dragonflight 10.1.0 has a game bug that was causing Pawn to show the wrong information on "currently equipped" tooltips. That bug is fixed in Dragonflight 10.1.5. Pawn will stop annotating "currently equipped" tooltips until 10.1.5 launches.
* Dragonflight: Added support for the 10.1.5 PTR.
* Dragonflight: Added support for Augmentation Evokers. If you're using Pawn in Automatic mode (the default), you don't need to do anything extra. If you're using Pawn in Manual mode, you'll need to import your own Augmentation scale or use (shift-click) the one that comes with Pawn. (Stat weights for Augmentation aren't available yet so it's a placeholder in this version of Pawn.)

### Version 2.8.1

* Dragonflight: Fixed a problem that could occur when showing Pawn's version number on 10.1.0.

### Version 2.8.0

* Updated for Dragonflight: Embers of Neltharion (10.1.0).

### Version 2.7.18

* Dragonflight: When you have the Onyx Annulet (the Forbidden Reach ring with primordial sockets) equipped, Pawn will ignore that ring for the purposes of showing you upgrades.

### Version 2.7.17

* Dragonflight: Enhancement shamans will no longer see daggers as upgrades.
* Wrath of the Lich King Classic: Added support for additional items with attack power and armor penetration rating in French, Latin American Spanish, European Spanish, Portuguese, Korean, Simplified Chinese, and Traditional Chinese. (Those items already worked in other languages.)

### Version 2.7.16

* Dragonflight: Pawn will now show you upgrade details when using the Revival Catalyst at Tyrhold.

### Version 2.7.15

* Fixed a bug where Pawn was undervaluing certain crafted items with two random stats.

### Version 2.7.14

* Dragonflight: Added support for loot in the the new Dragonflight Adventure Guide like in previous versions of the game. (Item tooltips will get upgrade arrows and so on, but I haven't added green arrows to the item icons themselves yet.)
* Dragonflight: Updated Pawn's database of gem stats to account for changes in 10.0.2. Any Dragonflight item with a socket will now be considered a couple of percentage points better than before.
* Dragonflight: Crafted items with a Quality level on the tooltip will no longer cause Pawn's Compare tab to say that the item has "special effects."
* Dragonflight: Fixed a bug where Pawn would cause a Lua error when turning the "show bag upgrade advisor" option on or off after WoW patch 10.0.2.

### Version 2.7.13

* Dragonflight: Pawn will no longer suggest socketing gems into items from the Shadowlands, unless you turn off the "Ignore sockets on low-level items" option. Onto the Dragon Isles!

### Version 2.7.12

* Dragonflight: Fixed another error that could occur in 10.0.2 when using Pawn-compatible bag addons while Pawn's bag advisor is OFF. (When that option is off, and a bag addon asks Pawn for help finding upgrades, Pawn just asks the game what it would have done. But the game removed its bag upgrade code in 10.0.2 so Pawn was freaking out.)

### Version 2.7.11

* Dragonflight: Yet another change to work with Pawn-compatible bag addons (thanks Merathilis!).

### Version 2.7.10

* Dragonflight: Additional fixes for Pawn-compatible bag addons (thanks Caedis!).
* Dragonflight: Fixed a bug I introduced in 2.7.9 that would cause your chat window to be filled with messages like "nil nil" if you were using a Pawn-compatible bag addon.
* Dragonflight: Fixed a problem that was preventing the "Equipped" shortcut buttons on Pawn's Compare tab from working after 10.0.2.

### Version 2.7.9

* Dragonflight: **In 10.0.2, Blizzard deleted the code for the game's built-in bag arrows. For now, green arrows in your bags won't work unless you have a Pawn-compatible bag addon installed.** You can still see upgrade advice when you hover over the item, just not on the item's icon itself.
    * This version includes an update so that Pawn-compatible bag addons will work again.
    * I'm as confused as you are.
* Dragonflight: Evokers in the starting zone who haven't chosen a spec will now see Devastation advice when in Automatic mode instead of Preservation. (It doesn't really matter right now because both of those scales are placeholders for the time being.)

### Version 2.7.8

* Dragonflight: Pawn's keybindings will now once again show up in the keybindings list without having to search for them by name.
* Dragonflight: Pawn now knows about the new gems from the Dragon Isles, but it won't suggest them until you start getting gear from there.
* Wrath of the Lich King Classic and Burning Crusade Classic: Fixed an error that would occur when socketing an item when using a custom scale for which there are three or more colored gems that have exactly the same value.

### Version 2.7.7

* Dragonflight: Updated to work with changes made to the game's comparison tooltips on the 10.0.2 PTR and beta.
* Dragonflight: Fixed the error that would occur when clicking the Pawn button in the Interface Options window.
* Adds support for a future version of Ace3's configuration window.

### Version 2.7.6

* All Classic versions: Pawn will not provide upgrade information to bag addons for now, to resolve some extreme performance issues that some players are having. (I hope to let bag addons on Classic versions add green arrows like you get on modern WoW again in the future!)

### Version 2.7.5

* German Wrath of the Lich King Classic: Added support for additional items with armor penetration rating.

### Version 2.7.4

* Dragonflight: The bag upgrade advisor (Pawn taking over the green arrows in your bags) now works with all styles of bags.
* Dragonflight: Fixed a problem where sometimes you couldn't right-click on items in your bags to use them.

### Version 2.7.3

* Fixed a harmless error that could occur when selling certain unusual types of items, such as caged battle pets.
* Burning Crusade and Wrath of the Lich King Classic: Fixed a problem where socket bonuses were sometimes being ignored in the advice given by the socketing advisor. (The item's values and upgrade %s were, however, not affected—just the shift-right-click window.)
* Dragonflight: Pawn now annotates the tooltip when hovering over the item to be crafted in the professions UI, so you'll see upgrade information (and item scores if enabled) when you hover.
* Russian Wrath of the Lich King Classic: Added support for additional items with armor penetration rating.

### Version 2.7.2

* Dragonflight: The bag upgrade advisor (Pawn taking over the green arrows in your bags) now works with the classic (non-combined) bags in WoW 10.0. (Thanks Triadian!)
* Simplified Chinese Wrath of the Lich King Classic: Added support for additional items with parry rating.

### Version 2.7.1

* Dragonflight: Fixed a problem where Pawn would display an error when evaluating armor for evokers.

### Version 2.7

* Dragonflight: Pawn now works on the Dragonflight beta and the WoW 10.0 PTR. Stat weights for evokers are placeholders.
* Shadowlands and Dragonflight: Fixed a problem where new characters (before level 10) could show item advice for blood death knights or another seemingly random spec when in Automatic mode.
* Wrath of the Lich King Classic: Northrend awaits! Pawn will no longer suggest that you put gems in your Burning Crusade items, unless you've turned off the "Ignore sockets on low-level items" option that's on by default. With the option on, Pawn will start suggesting you socket gems again when you start getting level 187 gear (about level 78).
* English Classic versions: Added support for a few items that add armor penetration rating in an unusual way.

### Version 2.6.7

* Wrath of the Lich King Classic: The individual schools of spell damage (of Fiery Wrath, etc.) will now show up on the Weights tab like they did in Classic Era and Burning Crusade Classic, though those stats are no longer found on Northrend items.
* Wrath of the Lich King Classic: Added a new version of the default protection paladin stat weights with some small adjustments to optimize for threat generation.

### Version 2.6.6

* Wrath of the Lich King Classic: Fixed Pawn's gem recommendations for Burning Crusade items on the Wrath pre-patch. (The Northrend gem recommendations were correct, but the Outland gems were still being recommended based on their old stats from Burning Crusade.)
* Wrath of the Lich King Classic: Added support for ranged attack power on more types of items in all languages.
* Wrath of the Lich King Classic: Added support for spell power on items "of Sorcery" in French and Latin American Spanish.

### Version 2.6.5

* The list of scales will now display a warning at the top if you don't have any scales visible. (Most of Pawn's features don't do anything if no scales are visible, but it's okay to ignore the warning if that's what you really want.)
* Wrath of the Lich King Classic: The first time you log in on a death knight after updating, Pawn will re-show all of the death knight starter scales if you don't have any custom scales shown.

### Version 2.6.4

* Wrath of the Lich King Classic: Ranged attack power will now show up in the list of stat weights and on the Compare tab again.
* Wrath of the Lich King Classic: Added support for armor penetration and expertise on more types of items in all languages.
* Wrath of the Lich King Classic: Added support for attack power on more types of items in European Spanish, Latin American Spanish, and Traditional Chinese.
* Includes Russian translation updates.

### Version 2.6.3

* Wrath of the Lich King Classic: Fixed a problem that started occurring after the latest Wrath update that caused Pawn to sometimes stop annotating tooltips for a while after you changed anything about your current scales (changing visibility, changing stat weights, etc.).
* Wrath of the Lich King Classic: Fixed a problem where some specs were getting hit, crit, and haste ratings of 1 instead of 0 or a fraction as intended.
* Wrath of the Lich King Classic: Fixed a typo that caused the default spell power weight for discipline priests to be 100⨉ what it was intended to be. Oops.

### Version 2.6.2

* Wrath of the Lich King Classic: The death knight starter scales now indicate in the name whether they're providing advice for tanking or DPS.
* Wrath of the Lich King Classic: Feral attack power now works as it did in Pawn 1.1 back when Wrath was new—it's not a real stat on items in Wrath, but it appears on tooltips when playing a druid. A value you assign to feral attack power will work the same as if it were a real stat, like before the pre-patch. You can assign points to melee weapon DPS or feral attack power, but you probably don't want to assign points to both.
* Wrath of the Lich King Classic: Fixed a problem where weapon DPS was contributing more to an item's score than intended when using the default stat weights.
* Traditional Chinese Wrath of the Lich King Classic: Pawn now supports Wrath Classic (including the pre-patch) in Traditional Chinese.
* German Wrath of the Lich King Classic: Includes a minor translation update.

### Version 2.6.1

* Wrath of the Lich King Classic pre-patch: Today's Wrath Classic patch broke addons that need to detect which version of the game you're playing, including Pawn. This version of Pawn should work correctly again after that change.

### Version 2.6

This version introduces support for the Wrath of the Lich King Classic pre-patch.

* There are all-new default stat weights for all classes and specs, including death knights, curated by HawsJon (thanks!). These should provide more accurate advice for level 80 and the mechanics changes in the pre-patch.
    * As always, simulating your character and maintaining custom stat weights will yield even better advice, specifically tailored for your character.
* Spell damage and spell healing have been converted into a single stat, spell power. Existing custom scales will be converted automatically by choosing the better of the two weights, and then you can continue to adjust as needed.
* Hit, crit, and haste have been converted from individual melee and spell ratings to a single rating each. Existing custom scales will be converted automatically by choosing the better of the two weights, and then you can continue to adjust as needed.
* Pawn now includes data for the Wrath of the Lich King Classic gems, but it won't start suggesting those gems until you start getting Northrend gear. You can still browse them on the Gems tab.
* There is currently no way to distinguish between armor and bonus armor—sorry, bear tanks.
* This version of Pawn will not work properly in Traditional Chinese on Wrath Classic due to an updated translation.

This version also includes minor fixes for Shadowlands, Classic Era, and The Burning Crusade.

* Shadowlands: Added Pawn annotations to the tooltips for converted items at the Creation Catalyst. (Thanks Triadian!)
* Classic: Fixed a problem with the default stat weights where Pawn was suggesting dual-wielding weapons for protection warriors and paladins instead of using a shield.

### Version 2.5.38

* Burning Crusade Classic: The new Shattered Sun gems for Content Phase 5 will now show up in recommendations.

### Version 2.5.37

* Fixed that annoying problem where the green tooltip border would overstay its welcome if you hovered over an upgrade item and then something else like a spell button.

### Version 2.5.36

* Burning Crusade Classic: Added support for new Zul'Aman items that use a different wording for their spell damage and healing. (Thanks wwwbbat!)

### Version 2.5.35

* Shadowlands: Includes new stat weights for all classes and specs from Ask Mr. Robot.
* Burning Crusade Classic: Pawn will now suggest Runed and Bright Crimson Spinel, as appropriate.

### Version 2.5.34

* Burning Crusade Classic: Fixed a problem where the spell damage portion of Teardrop Crimson Spinel was getting counted toward healing as well (30 healing and 8 spell damage, but it should be 22+8) in Russian.

### Version 2.5.33

* Shadowlands: Pawn no longer values domination sockets since domination shards no longer function outside of the Maw.

### Version 2.5.32

* Burning Crusade Classic: The new gems for Content Phase 3 will now show up in recommendations, and will be taken into account when determining the value of sockets on Black Temple gear.

### Version 2.5.31

* You can now type things like "/pawn tooltip 186767" or "/pawn tooltip 186459::::::::60:257:::1:7883:2:9:60:28:888" to reconstruct an item in-game, for example if you see its item ID on a screenshot from someone who has Pawn's "Show item IDs" option enabled. (You probably won't ever need to use this, but it should be handy for me!)
* Fixed MP5 detection on some items in the German version of Classic Era Season of Mastery. (Burning Crusade Classic and other languages were not affected.) (Thanks ruffiely!)

### Version 2.5.30

* Fixed a problem where domination sockets were undervalued in the default Ask Mr. Robot scales for tanks and healers.

### Version 2.5.29

* Fixed the look of the socketing advisor tooltip on WoW 9.1.5, which also fixes an error that started with 9.1.5.

### Version 2.5.28

* Fixed a problem where domination sockets could get counted twice.
* Fixed a minor bug where Pawn's socketing advisor would stay visible when shift-right-clicking an item with a prismatic socket and then shift-right-clicking an item with a domination socket, without first closing the socketing window.
* If you have scale values visible on tooltips (they're hidden by default), you can now hover over the Pawn button when inspecting another player to see their total scores (using _your_ character's scales) on Classic, like you can in Shadowlands.

### Version 2.5.27

* Items with only a domination socket will no longer show a blank socketing advisor when you shift-right-click them, since Pawn doesn't suggest domination shards.
* You can now assign a value to domination sockets on an item. For Pawn's default scales, I've chosen a very conservative value for the stat that assumes that you _aren't_ raiding Sanctum of Domination. The initial value I've chosen is 45× the value of Leech, which is provided by the Desolate Shard of Rev which anyone can easily attain without raiding. For someone who does raid Sanctum of Domination and has access to better shards and their class's domination set bonus, this default value will be far too low, so you'll want to increase it to something more appropriate.

### Version 2.5.26

* The "color tooltip border of upgrades" feature now works again without errors on the 9.1.5 PTR.
* Incorporated a couple of changes from players on CurseForge that will hopefully improve compatibility between Pawn and ArkInventory.
* Burning Crusade Classic: Added support for new types of items with holy spell damage in English, French, Russian, Latin American Spanish, European Spanish, Simplified Chinese, and Traditional Chinese versions of Burning Crusade Classic.

### Version 2.5.25

* Additional Pawn updates to accomodate changes made in French Burning Crusade Classic, and to fix a bug I introduced in the previous version that only affected French versions of the game.

### Version 2.5.24

* Pawn will now once again recognize specific schools of spell damage on items in French Burning Crusade Classic. (Other languages, Classic Era, and Shadowlands were not affected.)
* Made a couple of small changes to help make French compatibility problems easier to fix in the future.
    * For the curious, in French it's normal to put a space before AND after a colon, as in "Équipé : Augmente...". Sometimes, Blizzard uses a "non-breaking space" instead of a regular space before the colon, and a regular space after, which is also common. Unfortunately, they're not consistent; sometimes they just use two regular spaces. And you can't _see_ the difference, but to code, those two spaces are as different as A and Z. With this change, Pawn will now always treat non-breaking spaces and regular spaces the same.

### Version 2.5.23

* Fixes a harmless but annoying error that could occur when interacting with socketed items in Shadowlands.

### Version 2.5.22

* Fixed a few bugs relating to meta sockets in Burning Crusade Classic. The base values of helms with meta sockets will be (correctly) somewhat higher after this change, and the current values of a fully-socketed helm (if you have those turned on) may be significantly higher.
* Fixed a problem where Pawn couldn't read the damage stats on the few rare crossbows that deal an exact, non-random damage with every attack (Crossbow of the Albatross, Fine Light Crossbow) on French versions of Classic Era and Burning Crusade Classic. Other languages and other crossbows were not affected.
* Added some additional debugging information to help me understand some tricky aspects of gem calculations in the future. (That means even more chat spam when debug mode is on!)

### Version 2.5.21

* When using the option to ignore gems while leveling (which is _enabled_ by default) on Burning Crusade Classic, Pawn will now no longer suggest that you use gems on items with an item level below 100. This means that those items will get lower values, and also that Pawn will no longer suggest using green-quality gems in any item by default. You can restore the (approximate) previous behavior by disabling that option on the Options tab. (That option affects all characters.)
* Added support for more items with spell crit in English and French Burning Crusade Classic.
* A few Shattered Sun / Sunwell gems that don't appear until Burning Crusade Classic Phase 3 have been removed from recommendations, since they're not available yet.
* Fixed a bug where socket bonuses would always be ignored on items in Traditional Chinese Burning Crusade Classic.
* Fixed a bug on Burning Crusade Classic where the Compare tab would show a socket bonus even when it would be better to ignore the socket bonus and only use your best gems. (Item values and upgrade advice were not affected; this was just a display issue.)
* Fixed a harmless error that would appear when logging in on Traditional Chinese versions of WoW.
* Slightly improved performance on Italian Shadowlands.

### Version 2.5.20

* Pawn should finish its item calculations about 5% faster now.
* Added support for more types of items with melee and ranged crit rating in French, Latin American Spanish, European Spanish, Korean, and Simplified Chinese Burning Crusade Classic.

### Version 2.5.19

* Fixed an error that could appear when hovering over an item ("attempt to get length of field 'Values' (a nil value)").
* Added support for more types of items with different amounts of spell damage and healing on the same line of the tooltip in Russian Burning Crusade Classic.
* Added support for more types of items with MP5 in French Burning Crusade Classic.

### Version 2.5.18

* While leveling in Shadowlands (non-Classic), Pawn will now suggest potential upgrades to heirloom items that used to provide an experience boost, since those items no longer do and there's less of a downside to replacing them.
* Added support for more types of "the Sorcerer" items in Burning Crusade Classic in several languages.
* Added support for more types of items with MP5 in Simplified Chinese and Traditional Chinese Burning Crusade Classic.
* Added support for more types of items with different amounts of spell damage and healing on the same line of the tooltip in Traditional Chinese Burning Crusade Classic.

### Version 2.5.17

* I'm trying out a new workaround for a couple of game bugs that caused Pawn to work much more slowly on Classic Era and Burning Crusade Classic.
    * Other than just still not being fast enough, the most likely thing that might break with this change is Pawn missing some of the stats on items that appear in green text, such as ratings in Burning Crusade Classic. (I haven't spotted any bugs with those—but if anything did break, it's probably that.)
* Additional performance improvements that affect all versions of the game.

### Version 2.5.16

* Added support for more types of items with crit rating on German Burning Crusade Classic.

### Version 2.5.15

* Added support for more types of Wrath items (Fiery Wrath, etc.).
* Added "Thrown weapon" to the list of weapon types that you can add values to (or mark as unusable) on the Values tab for Classic Era and Burning Crusade Classic.
* Classes that can't use thrown weapons have them marked as unusable in the default scales, so by default they won't show as potential upgrades.
* Added support for more types of items with spell damage and healing on the same line of the tooltip, and more with MP5, on English Burning Crusade Classic.
* Added support for more types of items with crit rating on Russian Burning Crusade Classic.
* Fixed a couple of bugs causing health regeneration on items to not be recognized on French versions of the game.
* Further improved the formatting of how some item IDs are displayed.

### Version 2.5.14

* On Classic and Burning Crusade Classic, Pawn will no longer suggest mail as upgrades for hunters and shamans or plate for warriors and paladins before level 40 in some places.
* Added support for additional types of items with shield block rating and dodge rating.
* You can now use Enter and Escape to close the popups that appear when using the Scale tab (export, confirm delete, etc.).
* Pawn will now claim that fewer items have "special effects" on the Compare tab if the "special effect" is something at the top of the item tooltip like "Mythic." (This doesn't affect item values or upgrade advice in any way, just the orange diamond on the Compare tab.)

### Version 2.5.13

* Fixed a problem where Pawn was suggesting random items instead of cut Golden Draenite gems. (The item values and upgrade advice were correct; it was just showing the wrong item name. I apologize to anyone who tried to shove a two-handed mace into a yellow gem socket.)
* Fixed a problem where shamans were being treated as if they could dual-wield on Classic Era.

### Version 2.5.12

* Added support for items with spell penetration in Classic Era. (They're already supported in Burning Crusade Classic.)
* Added support for the handful of armor penetration items that will appear in later phases of Burning Crusade Classic.
* Worked around a bug in the Russian and Latin American Spanish versions of Burning Crusade Classic that would cause Pawn to show errors if you had items with a healing enchantment or random property.

### Version 2.5.11

* Included several gem cuts that were missing from suggestions, including Runed and Teardrop—sorry, casters!
* Fixed a problem where many of the gems suggested on Burning Crusade Classic were being suggested based on stats and colors that they had at different points in the game's history (Wrath or Cataclysm). You should see more sensible suggestions in the socketing advisor, and the values of socketed items may slightly increase.
* Added support for "of Healing" and "of the Prophet" items on Burning Crusade Classic. (Thanks to neaves for tracking down the items and a suggested fix!)
    * On Latin American Spanish and Russian, "of Healing" items currently don't show the spell damage granted. Once that bug is fixed, Pawn will need an additional change to handle those items properly.
* Fixed an error that would occur on Burning Crusade Classic when looking at an item that has sockets but no meta socket. (Thanks to ahakola for a suggestion and the many people who reported this.)
* Fixed a minor issue with how some item IDs were displayed (a missing colon).

### Version 2.5.10

* Meta gems are now supported. You can manually assign a weight per scale to the special meta gem effects such as "Minor Run Speed Increase" or "1% Spell Reflect"; the stat portion of a meta gem will be calculated for you. (A good starting point is 36× the value of your primary stat.)
* Fixed a problem where Pawn wouldn't work at all on Italian Shadowlands.
* Fixed a problem where feral attack power wasn't working on English Burning Crusade Classic.

### Version 2.5.9

* On Burning Crusade Classic, when determining a socketed item's value, Pawn will now decide whether the item's value would be maximized by following the socket bonus, or ignoring the bonus and using all of the same type of gem.
    * The socket bonus will also be taken into account for the advice given in the socketing advisor popup.
    * The socket bonus will also be shown on Pawn's Compare tab whenever the item's value would be maximized by following the socket bonus.
* Fixed a problem with wands that deal holy damage on all Russian versions of WoW.
* Fixed a problem with some items that grant mana-per-5 on Russian Burning Crusade Classic.

### Version 2.5.8

* Pawn now includes colored sockets in the value of an item like it does for prismatic sockets. Colored sockets are assigned a value automatically based on the best gems that fit that socket's color of an appropriate quality level for the item. Like prismatic sockets, there's no way to manually override the value of a colored socket or to fine-tune the quality level of the gem used in the calculation.
* Colored and meta sockets are now shown on Pawn's Compare tab.
* The socketing advisor will now appear for socketed items in Burning Crusade Classic.
* Added support for more items with spell hit rating on Burning Crusade Classic.

### Version 2.5.7

* Added the Gems tab in Burning Crusade Classic.
    * Gems with Haste are not currently visible, since they won't appear until Black Temple opens.
* The value of stamina in the Classic and Burning Crusade Classic default scales for DPS specs was too high and has been reduced to a more reasonable level.
* Added support for some additional caster enchantments on English Classic and Burning Crusade Classic. (This was accidentally listed in the notes for 2.5.6 in some places, but it's not fixed until 2.5.7.)
* Simplified the look of some item IDs when the Show Item IDs option is enabled.

### Version 2.5.6

* Fixed a few problems with items that give bonuses to a single type of magic damage in European Spanish Burning Crusade Classic.

### Version 2.5.5

* Added support for items with feral attack power on Burning Crusade Classic.
* Added support for more items with defense rating on Burning Crusade Classic.
* Added support for more items with hit rating on Burning Crusade Classic.
* Added support for more items with spell hit rating on Simplified Chinese Burning Crusade Classic.
* Fixed problems with weapon damage in Traditional Chinese Burning Crusade Classic.
* Fixed a problem with Outland items with melee and ranged crit rating on European Spanish Burning Crusade Classic.
* Fixed a problem with items with school-specific spell damage on European Spanish Burning Crusade Classic.

### Version 2.5.4

* Fixed the calculation of DPS of wands on Portuguese and Korean Burning Crusade Classic.

### Version 2.5.3

* Added support for more Outland items with spell crit rating on Burning Crusade Classic.
* Added support for more Outland items with the same amount of spell damage and healing on Burning Crusade Classic.

### Version 2.5.2

* Fixed a problem where Pawn missed crit rating on some Outland items in Burning Crusade Classic.
* Fixed a problem where Pawn couldn't determine the DPS of wands in French Burning Crusade Classic.
* Fixed many problems where Pawn missed stats in European Spanish Burning Crusade Classic.

### Version 2.5.1

* Added support for various items with hit rating and attack power that weren't being handled properly before.
* Fixed a problem where items with different values of spell damage and healing on the same line of the tooltip were getting the two stats reversed, even though I literally _triple-checked_ that before releasing Pawn 2.5.
* Minor updates to the German translation.

### Version 2.5

Introducing: Pawn for the Burning Crusade Classic pre-patch.

**Important:** If you imported custom scales on Classic and are continuing to Burning Crusade Classic, you'll need to update your weights for all of the percentage-based stats when you get the pre-patch. If, for example, your value for Crit is 10, an item that gives 1% crit would be worth 10 points on Classic, but would be worth 80 in Burning Crusade Classic and the pre-patch, because that item will change to have 8 crit _rating_. Pawn won't make any automatic changes to your custom scales. But, if you're using the default stat weights that come with Pawn, you don't need to do anything.

* Added support for all Burning Crusade Classic languages: English, French, German, Korean, Portuguese, Russian, Latin American Spanish, European Spanish, Simplified Chinese, and Traditional Chinese.
    * Known issue: The Spanish PTR currently has a bug where items are showing spell hit and spell crit as percentages instead of ratings. Pawn currently processes these items correctly, but once the bug is fixed, Pawn will need an additional adjustment to work again.
    * Known issue: The Russian PTR has the same problem with spell hit.
* Added support for new stats: Expertise Rating, Resilience Rating, Haste Rating, Spell Haste Rating, and Spell Penetration.
* Added support for new combat ratings present on Classic gear: Hit Rating, Spell Hit Rating, Crit Rating, Spell Crit Rating, Dodge Rating, Parry Rating, Block Rating, and Defense Rating.
* Added support for items that give different amounts of spell damage and healing on the same line (Amulet of Flowing Life, etc.).
* The default stat weights on Burning Crusade Classic have been updated to accommodate the combat ratings change.

### Version 2.4.18

* Russian WoW Classic: You should no longer see a warning about addon incompatibility when logging in.

### Version 2.4.17

* Added ArkInventory integration, contributed by a Pawn fan named Matthew. (Well, I don't know if he _said_ he's a fan. I'm assuming here.)
    * When you have ArkInventory and ArkInventoryRules enabled, you can use the `pawnupgrade()` rule in ArkInventory to run a Pawn comparison on items in your inventory for sorting. This will return true if the item is an upgrade and false if it is indeterminate or not an upgrade. To determine if something is not an upgrade, use `pawnnotupgrade()`. This rule will return true if the item is definitely not an upgrade, and false if it is indeterminate or an upgrade. This can be used for auto-sell rules, such as `bind(3) and pawnnotupgrade()`.

### Version 2.4.16

* Shadowlands: Pawn will now suggest the +16 stat jewel clusters instead of +12 stat gems for items level 175 and higher.

### Version 2.4.15

* Shadowlands: Updated stat weights for Guardian Druid based on a new simulation from Ask Mr. Robot.

### Version 2.4.14

* Spanish, Shadowlands only: Fixed a problem where off-hand frill items were being misidentified as off-hand weapons, so they didn't show upgrades or values for casters. (This problem didn't apply to Classic or to other languages.)
* Spanish, Spain only, Classic only: Fixed a problem where an error message appeared when logging in.
* Spanish: Fixed detection of Avoidance and Block Value on some items in certain situations.

### Version 2.4.13

* Shadowlands: I've included a new set of stat weights from Ask Mr. Robot yet again—the most notable changes will be for healers, who will see the value of mastery increased significantly.
* Improved a few bits of the Italian translation.

### Version 2.4.12

* Shadowlands: Pawn 2.4.11 included the wrong set of stat weights; this version includes the stat weights that were _intended_ to come with 2.4.11. Apologies for the error!

### Version 2.4.11

* Shadowlands: Pawn now includes new default stat weights for all classes and specs from Ask Mr. Robot, optimized for typical characters in Mythic Keystone dungeons. These should give you much better gearing advice than the previous defaults, but remember that you'll always get the most accurate advice for your character if you import stat weights from your favorite simulator (like Ask Mr. Robot).
* Pawn's "compare item left" and "compare item right" keybinds work with world quest item rewards once again.

### Version 2.4.10

* Worked around a bug in WoW that was causing Pawn to show incorrect upgrade information for some Shadowlands quest rewards.
* Fixed a bug where clicking links in chat and then right-clicking the window that appeared would open Pawn's Compare tab even if it was for something that wasn't an item, such as an achievement.

### Version 2.4.9

* Added Pawn annotations for tooltips of item rewards in the Great Vault. (I think. Thanks Crazy Carl!)

### Version 2.4.8

* Pawn can now recover and continue working if another addon changes any of the class colors and does so incorrectly.

### Version 2.4.7

* Changed the graphics in the Pawn UI to look more Maw-like.
* WoW Classic: In German, mail armor is now properly detected again after the Naxxramas patch.

### Version 2.4.6

* Pawn will no longer appear as "out of date" after updating to WoW 9.0.2.

### Version 2.4.5

* WoW Classic: In Russian, shadow spell damage is now properly recognized on items. (This problem didn't affect other schools of magic or other languages.)

### Version 2.4.4

* Pawn's bag icons should now cooperate with Can I Mog It?'s bag icons again. Special thanks to the author of that addon, who inspired a much simpler solution that what I had come up with.

### Version 2.4.3

* Pawn now has a more complete set of gem recommendations, including new gems from the Shadowlands. For example, for resto shamans on an ilvl 100 item, Pawn will suggest five different +4 crit gems from different expansions, so you can buy the one that's cheapest.
    * This is just new recommendations, not a new feature—there still isn't a way to further customize gem quality levels to your exact tastes, but that's still on the to-do list.
* Pawn was a little overzealous in resetting data that might have been affected by the level squish, so I've changed the way it works to be less annoying for people who have a lot of alts.

### Version 2.4.2

* **Pawn's bag arrows integration will no longer work by default with custom bag addons.**
    * The game no longer allows customizing that functionality while in combat, so before this change, Pawn's bag arrow integration caused errors while performing certain actions in combat, such as swapping weapons from the character sheet. Disabling support for custom bag addons is unfortunately the only way I can work around this.
    * To work around this, custom bag addons that call IsContainerItemAnUpgrade directly can use PawnIsContainerItemAnUpgrade when available instead, falling back to IsContainerItemAnUpgrade if it's nil. Then Pawn will control the bag arrows like it did before.
* Pawn will now show two-handed weapons as potential upgrades for two-handed Frost Death Knights. If you're all about the dual-wielding life and want to turn this back off, you can go to Pawn's Values tab, select "Axe: 2H" (or any other 2H type) under "Weapon types", and then select "Don't show upgrades for 2H items."
* You should no longer see a warning message about addon compatibility when playing on Russian WoW 9.0.

### Version 2.4.1

* WoW Classic: Hopefully fixed an error that occurred when turning in a quest.

### Version 2.4

* Welcome to WoW 9.0 and the level squish! Pawn had to wipe its memory of everything it knew about your characters before the squish since none of that information is correct anymore, so for a little while it might show you upgrades that aren't actually upgrades until it learns about your sweet epics. This shouldn't last long, and will automatically resolve itself as you play.
    * This version is meant for WoW 9.0 (Shadowlands pre-patch) and WoW Classic only.
* Pawn should give reasonable gem recommendations and calculations in this version, but I'll continue to refine them in the coming days to give more helpful suggestions at lower levels.
* Default stat weights have not been updated. Players participating in high-level raiding may want to import custom weights from a simulator instead of using the built-in guidance.
* The Corruption stat has been removed, since it no longer has any effect on your character and appears greyed out.
* Fixed a problem where if a quest gave you a useful item and a junk item (such as a gray artifact power item from Legion), Pawn would sometimes fail to show upgrade arrows on the non-junk item.

### Version 2.3.36

* WoW Classic: Added support for parry chance on items. (The UI has been there all this time, but it didn't actually work. Oops!)
* WoW Classic: Fixed some problems with Benediction and some other items with spell damage and healing that only occurred when playing in Simplified Chinese.

### Version 2.3.35

* WoW Classic: Added support for dodge arcana and cloak enchantments.

### Version 2.3.34

* WoW Classic: Pawn will no longer incorrectly show axes as potential upgrades for rogues.
* WoW Classic: Added support for Fel-Infused Leggings in Simplified Chinese, which work differently from seemingly every other item in the game with shadow spell damage because Blizzard hates me.

### Version 2.3.33

* WoW Classic: Added support for "of Sorcery" items.

### Version 2.3.32

* I broke the Korean version in 2.3.31—it's fixed now.
* One more small update to the German translation.

### Version 2.3.31

* Shadowlands: Adjusted the level at which characters get their armor specialization ability.
* Shadowlands: Pawn will now start showing upgrades to Legion artifact weapons again.
* Updated the German translation, thanks to SunnySunflow.

### Version 2.3.30

* **This release adds Shadowlands compatibility to Pawn.**
* Shadowlands: Pawn's UI will no longer be see-through.
* WoW Classic: Fixed a problem where Pawn would no longer show your score totals when hovering over the Pawn button after equipping a relic-slot item.
* WoW Classic: Fixed a problem where shadow spell damage was no longer being recognized in Simplified Chinese. (Other languages weren't affected.)

### Version 2.3.29

* One-handed maces and daggers will no longer incorrectly appear as potential upgrades for demon hunters, since they cannot equip them.

### Version 2.3.28

* I rearranged the Values tab, making the stat list wider, to make it easier to use in languages where some stat names are very long like "Puissance d'attaque en changeforme."
* Various minor updates to the sizes of things in the UI to make Pawn more pleasant to use in a variety of languages.
* Lots more updates to the French translation.

### Version 2.3.27

* Significant updates to the French translation, courtesy of CerealCH.

### Version 2.3.26

* Fixed a rare error that could occur when looking at very unusual rings.
* Pawn is now compatible with a slightly wider array of item tooltip comparison addons.
* WoW Classic: Fixed a problem where spell damage on some items in French wasn't being recognized. (Other languages weren't affected.)

### Version 2.3.25

* Fixed a problem where if scale values on tooltips were enabled, and you had a trinket with no stats (such as Pocket-Sized Computation Device or most trinkets in WoW Classic), Pawn wouldn't show the total score of all of the items you're wearing when hovering over the Pawn button on the character sheet.
* Fixed a problem where Leech (Parasitar / Robo de vida) was not recognized on items in either Spanish version of WoW.
* WoW Classic: Fixed multiple problems reading numbers when playing in French introduced by the latest patch for WoW Classic. (Battle for Azeroth isn't affected.)

### Version 2.3.24

* WoW Classic: Fixed a problem where Pawn would cause an error when using the "Track for each scale (advanced)" option because it would try to scan your equipment sets, which don't exist on Classic.

### Version 2.3.23

* Battle for Azeroth: Pawn now works in the new(-ish) 8.3.0 auction house.
    * Important: Items with random stats ("of the _____") will be undervalued on the main auction house browsing page, and will be unlikely to appear as upgrades. When you click the item name to see all of the individual auctions for that item, _those_ items will get accurate rankings from Pawn. (This is because the game groups multiple similar items with varying stats together on the initial screen, but the items listed on the second screen have exact stats that Pawn can evaluate.)

### Version 2.3.22

* WoW Classic: Fixed a lot of additional problems with the European Spanish version of WoW Classic. (Latin American Spanish and Battle for Azeroth weren't affected.)

### Version 2.3.21

* WoW Classic: Fixed a problem where Pawn couldn't read damage on weapons in the European Spanish version of WoW Classic. (Latin American Spanish and Battle for Azeroth weren't affected.)
* WoW Classic: Fixed a problem where Pawn couldn't read damage on wands in the Portuguese version of WoW Classic.
* WoW Classic: Improved the Simplified Chinese translation.

### Version 2.3.20

* WoW Classic: Fixed an issue where the new Classic stat weights included with Pawn valued stats like crit chance as if they were the Burning Crusade-style ratings, not percentages, so all of the percentage-based stats were severely undervalued. (This has no effect on you if you're using your own stat weights, or if you're playing Battle for Azeroth.)

### Version 2.3.19

* I worked around a bug in BankItems and other addons that use the old auction house that was causing Pawn to fail catastrophically.
* Pawn will now work with even more complicated corrupted items than before ("didn't expect to find 11 bonus IDs").

### Version 2.3.18

* WoW Classic: Pawn now includes a full set of starter scales for each class and spec courtesy of [HawsJon](http://tbcwowaddons.weebly.com/pawn.html). These stat weights were originally designed for use on The Burning Crusade, not Classic, but they're the best resource for Classic stat weights that I've found so far.
    * Druids have two scales for feral: DPS (cat) and tank (bear), since your preferred role will dictate which stats are most valuable.
    * Rogue off-hand weapons use different weights than other rogue gear, so there's a fourth scale for rogues that you should only use when comparing items for your off-hand slot.
* Removed an error message that appeared when playing in Spain.

### Version 2.3.17

* Pawn can now handle more complicated items than before. This fixes a problem where you could get an error like "didn't expect to find 9 bonus IDs" after looting a very complicated item.

### Version 2.3.16

* Updated German translation.

### Version 2.3.15

* WoW 8.3 PTR: Added support for the Corruption stat. If you assign it a value, you probably want to assign it a _negative_ value.
* WoW 8.3 PTR: Fixed a problem where high-level weapons would cause errors when playing in French.

### Version 2.3.14

* WoW Classic: Scale tags can now specify a class like on retail. When you import a scale that specifies a class, Pawn will now automatically mark all of the weapon and armor types that class can't equip as unusable just like it does on retail. (Specs included in scale tags for Classic will be ignored.)
* WoW Classic: For Korean players, wand damage should now be interpreted correctly and no longer produce an error message.
* WoW Classic: Fixed a problem where the retail-only option to only use your class's preferred armor type after level 50 was still showing up on leather, mail, and plate armor.
* Improved the "Items with this are unusable" text on the Weights tab in English.
* Made a small tweak to the Pawn UI's tabs to help people who use custom fonts.

### Version 2.3.13

* Updated the Pawn logo.
* Pawn dialogs that ask for scale names, and the delete scale confirmation dialog, have been returned to the more compact appearance that they had in version 2.3.10 and earlier.
* WoW 8.3 PTR: Fixed a problem where Pawn would no longer load on the PTR.
* WoW Classic: Ranged weapons are now properly supported.
* Added a special surprise.

### Version 2.3.12

* When exporting Pawn scale tags, unusable stats will now appear simply as "Stat=X" instead of "Stat=-1000000".
* WoW Classic: A basic starter scale for each class is now available.
    * The starter scales include default values for all stats relevant to the class, loosely based on the game's item level formula. (They're very similar to the default stat weights that came with Pawn a decade ago.)
    * There is just one starter scale per class, so for example, the druid template has values for Strength, Agility, Intellect, _and_ Spirit.
    * The appropriate starter scale will be automatically enabled when starting Pawn for the first time (if you don't already have any scales) so it does _something_.
    * I still _highly_ recommend customizing the default values.
    * The "Template" button on the Scales tab is now available, and creates a new scale based on your class's starter scale.
* WoW Classic: Pawn will now allow items that aren't your class's preferred armor type to be considered as upgrades after level 50, since non-cloth healers using cloth armor was commonplace and optimal in early WoW. _[Vger wistfully remembers her Crimson Felt Hat from Strat...]_
    * The option that appears to enable this feature whenever you select an armor type on the Weights tab has been removed.
* WoW Classic: The Manual button on the Scales tab is now visible, even though you can't switch to Automatic on Classic so the button is always selected. (Other parts of the Pawn UI refer to "switching to Manual mode" and I didn't want to have to change them all.)

### Version 2.3.11

* WoW Classic: Now supports Korean and Traditional Chinese. With that, Pawn now supports all WoW Classic languages!
* WoW Classic: Fixes for frost spell damage in Simplified Chinese.
* The Import and Export windows for scale tags are now larger and can be closed with the Esc key.
* If you experience a problem with Pawn incorrectly finding the stats for an item, you can put that item into the Compare tab and then Alt+click it to see a full list of the item's stats and a command that can be used to see the same item on a different computer. (You probably won't have a reason to use this unless I ask you to.)

### Version 2.3.10

* Additional updates to the Simplified Chinese translation.
* WoW Classic: Now supports Russian, thanks to drcrazy777.

### Version 2.3.9

* Additional updates to the Simplified Chinese translation from wolfcon.

### Version 2.3.8

* WoW Classic: Now supports Portuguese.
* WoW Classic: Now supports Simplified Chinese, thanks to wolfcon.
* Some updates to the Russian translation, courtesy of drcrazy777.

### Version 2.3.7

* WoW Classic: Now supports Spanish and German.

### Version 2.3.6

* WoW Classic: the Compare tab will now refresh itself after a moment to make sure it has the latest stats from your items.

### Version 2.3.5

* /pawn compare can now compare two items at once: /pawn compare left 12345 right 67890
* Fixed a bug introduced in Pawn 2.3.0 that made it impossible to import a scale with a class and spec specified the first time you tried.
* Fixed problems with baguette damage in French WoW.

### Version 2.3.4

* WoW Classic: Now supports French in addition to English.
* Fixed a problem introduced in WoW 8.2.5 where Pawn wouldn't recognize numbers 1,000 or larger in the Russian version of WoW—not the same one as for French and Spanish!

### Version 2.3.3

* Added a new Pawn slash command: /pawn compare. You can use this as an alternate way to put items into Pawn's Compare UI. For example, "/pawn compare left 16795" puts Arcanist's Crown into the left slot of Pawn's Compare tab.
    * The compare command accepts item IDs, "item:12345:0:0" strings, or full shift+clicked item links ("/pawn compare [Arcanist's Crown]").
    * If your PC hasn't downloaded the stats for an item yet, the command might not do anything the first time. Try it again (Enter, Shift+Up, Enter) after a second and it should work the second time.
    * Addon authors can use "PawnUI_SetCompareItemAndShow(1, 16795)" to accomplish the same thing. (1 for left, 2 for right.)
* Fixed a problem where armor was being ignored in French WoW.
* WoW Classic: Worked around a problem where Pawn would sometimes not see all of the stats on an item (typically, the "green stats").
    * This workaround will result in slightly lower performance on WoW Classic. I'm still investigating a better long-term solution.
    * For the curious, it's because the game client would get a partial list of stats for the item, then Pawn would do its calculations on that, and then shortly afterward the game would get the rest of the stats for the item, but at that point Pawn didn't know that it needed to re-scan the item, so it was evaluating the item based on just the first batch of stats it got.
* WoW Classic: Removed "All Resistances", which does not appear to exist on any items in Classic.
* WoW Classic: Added support for "of Concentration" items.
* Russian and Chinese: For consistency, Pawn's "debug" and "backup" slash commands are now always in English like they are for all other languages.

### Version 2.3.2

* Fixed a problem introduced in WoW 8.2.5 where Pawn wouldn't recognize numbers 1,000 or larger in the French and European Spanish versions of WoW.
* I introduced a system that will make Pawn a little easier to translate in the future, and make it more resilient to changes in the way that non-English versions of WoW display numbers.
* WoW Classic: Added support for ranged weapon DPS, "of Defense" items, and probably more stuff I forgot about.

### Version 2.3.1

* WoW Classic: Added support for "of Eluding" items.

### Version 2.3

Consider this version a full release for Battle for Azeroth and a beta for WoW Classic. WoW Classic is supported for English only in this version. Pawn does not include any built-in scales for WoW Classic, so you'll need to create your own scales from scratch, or import them. Not all Pawn features exist on WoW Classic, and some features are incomplete.

* There are no new features for Battle for Azeroth in this version. If you run into any issues on the live/retail realms, you can return to 2.2.x and shouldn't miss out on anything.
* The "show item level upgrades" feature will default to OFF in Classic. (But, if you've already used one of the earlier versions of Pawn on Classic, that option may already be on, so turn it off manually if you don't want it.)

### Version 2.2.46

* If you've used an addon to hide item levels from your items, but still have Pawn's "show item level upgrades" option turned on (that's the default), Pawn will now show the item level increase at the bottom of the tooltip instead.
* Fixed a problem where Pawn could forget your best items after logging out, if using the "track for each scale (advanced)" feature.

### Version 2.2.45

* Includes updated stat weights from Ask Mr. Robot for all classes and specs.

### Version 2.2.44

* Pawn will now show equippable items that are a higher item level than what you currently have as upgrades too, even if they aren't stat upgrades. (You can turn this new behavior off on Pawn's Options tab.)
    * This feature currently doesn't take Unique-Equipped rings into account. If you happen to equip two different item level copies of the same ring, Pawn could consider both of them your best two rings and thus "forget" about your previous second-best ring.
* Some minor performance improvements when logging in.
* Fixed a problem where characters with artifacts equipped could get upgrade recommendations for types of items they can't equip, such as wands for death knights.
* Fixed a harmless error that appeared when logging in on a Russian client.
* Lots of updated German translations, courtesy of SunnySunflow.

### Version 2.2.43

* Removed a harmless error that would occur when shift-right-clicking Pocket-Sized Computation Device.

### Version 2.2.42

* Added support for the new 60-stat epic gems from Nazjatar.

### Version 2.2.41

* Some minor changes to try to work around a problem where Pawn tries to compare a new item versus an old item but it doesn't know the stats of the old item, and it causes an error.

### Version 2.2.40

* Removed some old code that isn't necessary anymore in 8.1.5.

### Version 2.2.39

* Fixed an additional problem with an "ItemButtonTemplate" error that would appear if you have the "/console scriptErrors 1" setting on.
* Fixed a problem where Pawn would show an unnecessary error message to French players. You know, the one I said I fixed in 2.2.37.

### Version 2.2.38

* Fixed some problems with the Compare tab's visuals introduced by patch 8.1.5.

### Version 2.2.37

* Fixed a problem where Pawn would show an unnecessary error message to French players.

### Version 2.2.36

* New stat weights from Mr. Robot for all classes and specs!

### Version 2.2.35

* Increased the item level threshold at which Pawn will start suggesting BfA rare-quality gems.
* Added a warning Pawn detects that you're using an addon like Combat Numbers Separator that might cause it to give bad advice. (Let me know if you see this with only Pawn active!)

### Version 2.2.34

* Fixes to prevent errors involving "WorldMapTooltip" from occurring on WoW 8.1.5.

### Version 2.2.33

* Better compatibility with DejaCharacterStats.

### Version 2.2.32

* A debug-only option that I added long ago will now automatically turn itself off if you turned it on and then forgot about it. ("Not caching because the item didn't have any stats" and other similar messages.)

### Version 2.2.31

* Fixed a problem that occurred on the Spanish (EU) version of WoW (not the Mexico version or other languages) where items with 1,000 or more of a stat were being evaluated incorrectly.

### Version 2.2.30

* Includes new, updated stat weights for all classes and specs from Ask Mr. Robot's simulations to give you better, more accurate advice in raids.

### Version 2.2.29

* Fixes for Brazilian Portuguese.

### Version 2.2.28

* Pawn will no longer suggest weapon upgrades for mistweaver monks as if they could dual-wield.
* Adjusted gem recommendations.

### Version 2.2.27

* Pawn's relic upgrade features are now disabled by default, and I plan to remove them entirely in a future version.

### Version 2.2.26

* Items with sockets will now be valued somewhat higher than before, to account for the new gems in Battle for Azeroth jewelcrafting.
* Fixed a problem where sometimes you'd get an error when looking at items that your PC hadn't downloaded the stats for yet.

### Version 2.2.25

* Fixed some more issues with artifact weapon level comparisons (notably, comparing versus the surprisingly crappy weapons you get during the Battle for Lordaeron questline).
* Fixed the average item level display on the Inspect window when hovering over the Pawn button.

### Version 2.2.24

* When comparing an artifact weapon with a non-artifact weapon, Pawn now just shows upgrade arrows based on the item's level. Artifact weapons are complicated, and this seemed like the most helpful and least confusing way to provide guidance.

### Version 2.2.23

* Fixed a bug where Pawn could skip one of your equipment sets when looking for your best-in-slot gear when the "upgrade comparisons: track for each scale" option was enabled.
* Updated artwork.

### Version 2.2.22

* Pawn will no longer tell you that it's probably not worth your time putting gems in anything below ilvl 800. (I changed the threshold to 153, and I'll change it again when BfA launches.)
* Pawn will now show upgrades for your artifact weapons (and off-hands) on all level 110+ characters.
* More gem updates in preparation for the Battle for Azeroth jewelcrafting recipes.

### Version 2.2.21

* New default stat weights for the Battle for Azeroth pre-patch 8.0 for all classes and specs!
* Fixed some problems that occurred when the "Upgrade comparisons: Track for each scale" option was selected.

### Version 2.2.20

* More gem updates for the Battle for Azeroth item level squish.

### Version 2.2.19

* Updated for WoW 8.0 and the Battle for Azeroth item level squish. Due to item level changes, gem recommendations may be a little strange at lower levels; let me know if you see something that seems very wrong, and let me know which item and gem and the item levels of each.
* Stat weights have not been updated since WoW 7.x. They're still the latest from Ask Mr. Robot; most likely it will take a couple of months to account for all of the expansion changes and produce reliable new stat weights.

### Version 2.2.18

* Fixed an occasional incompatibility with TradeSkillMaster where upgrade arrows would appear in bags too often. (Special thanks to Curse user Katmandu29a.)

### Version 2.2.17

* Fixed a bug where relic upgrade info wasn't visible on tooltips anymore when the "align values to right edge of tooltip" option was enabled.

#### Version 2.2.17a

* Fixed a problem with the German translation of relic upgrade notifications.

### Version 2.2.16

* Updated the default Ask Mr. Robot scales for all classes and specs.

### Version 2.2.15

* Added a fix to make Pawn compatible with the German version of WoW 7.3.2 courtesy of Salty from Curse.

### Version 2.2.14

* Pawn will now suggest blue-quality gems on heroic Tomb of Sargeras gear or better, and the epic-quality gems on heroic Antorus gear.
* Translation updates for German courtesy of Salty from Curse.
* (Version 2.2.14a) Translation updates for French courtesy of Kangourousse from Curse.

### Version 2.2.13

* More language updates for WoW patch 7.3. (If I do four of these updates I get a special cache full of epics.)

### Version 2.2.12

* Fixed a problem introduced by WoW patch 7.3 that caused Pawn to not work properly in the Spanish (Spain) version of WoW.
* More updates for WoW patch 7.3.

### Version 2.2.11

* Updates for compatibility with WoW patch 7.3.

### Version 2.2.10

* Added a compatibility fix for AethysRotation and other addons that scan your artifacts while you're logging in.

### Version 2.2.9

* Stat weights for all classes and specs have been updated based on hotfixes, balance changes, and new simulations.
* Pawn will now suggest blue-quality gems only on items that are higher than level 900.

### Version 2.2.8

* Added new guidance and stat weights for all classes and specs to account for changes in WoW patch 7.2.5. The new weights are optimized for Mythic Keystone dungeons a higher gear level (870) than in previous versions of Pawn, given how quickly one can gear up alts currently.
    * In addition, the new weights for Assassination Rogues now assume that you use Master Poisoner.
* Fixed a problem in Korean WoW that was introduced in 2.2.7.
* Additional changes to French support to improve performance for players in all languages.
* Lots of translation updates for Portuguese courtesy of Pawn fan tiagopl. (No updates for other languages in this update.)

### Version 2.2.7

* Pawn is now compatible with the French version of WoW patch 7.2.5.

### Version 2.2.6

* Pawn will now wait to start suggesting relics for the third slot of your artifact until you've actually unlocked it. (I thought it would be helpful for collecting a relic before you finish the questline, but it's proven to be annoying and misleading in practice.)

### Version 2.2.5

* Made a change to try to improve integration with Bagnon.

### Version 2.2.4

* Fixed a bug in Pawn where for some low-level characters, Pawn wouldn't recognize that one of your artifact's relic slots was locked, and would suggest relics for that slot.

### Version 2.2.3

* English: Fixed a problem where the Survival Hunter artifact Talonclaw didn't ever show relic upgrades. (It's possible that this problem exists for other artifacts—it would occur any time that the artifact had a different name on the item tooltip versus the shift-right-click artifact pane.)

### Version 2.2.2

* Worked around a game bug where WoW was saying that BoE relics looted at level 110 and then passed to lower-level characters would get fewer ilvls from that relic than they actually would.
* Some other addons simulate shift-right-clicking on your artifact at logon to get information about it. This caused Pawn to sometimes receive incorrect information about your artifact, which would cause it to overestimate how much of an item level upgrade a relic would be. Pawn will now detect when this is happening and ignore the bad information it received.
* Russian: Includes translations for new relic features.

### Version 2.2.1

* Fixed a bug in Pawn 2.2 where items in a player's bags that required a higher player level and couldn't be equipped were still getting green arrows.
* Pawn will no longer work with WoW 7.1.5.
* English: Relics that give a single level increase will now say "+1 level" instead of "+1 levels".
* Russian: Hopefully fixed some of the catastrophic problems that started occurring with patch 7.2.
* Italian: Includes translations for new relic features.

### Version 2.2

* Includes fixes for compatibility with WoW patch 7.2.
* Pawn will now highlight relics that are an item level upgrade to one or more of your artifacts. Note that this upgrade feature is completely separate from Pawn's existing upgrade features—it's based on item level increase, not stats, and your custom scales are not used in any way.
    * This feature won't work until after you shift-right-click your artifacts. You only have to do that once (for each artifact) after upgrading to Pawn 2.2.
    * This feature will work for all of your artifacts regardless of which spec you're in.
    * Top-tier players who want to min/max specific artifact traits rather than focusing purely on their artifact's item level may want to turn this feature off—see Pawn's Options tab to do so.
* Pawn will now suggest the cheap 100-stat gems on more items.

### Version 2.1.18

* Fixed a bug where balance druids could see weapons appear as upgrades to their off-hand frill items, as if they could dual-wield.

### Version 2.1.17

* Updated the Ask Mr. Robot default scales for most specs. (The ones that didn't change already had the latest stat weights.)

### Version 2.1.16

* When copying built-in scales, the spec icon (as well as other internal details) will now be copied as well.
* The Compare tab will now refresh itself whenever it's shown, so changing scale values or an option that affects calculations like "ignore sockets on low-level items" will have an immediate effect.
* Fixed a minor bug where one of the details of each scale was being saved incorrectly. (Neither the bug nor the fix should have an immediate impact as the feature to use that detail isn't available in Pawn yet.)

### Version 2.1.15

* Updated default stat weights from Ask Mr. Robot for The Nighthold and the latest hotfixes.
* When the Pawn button is set to the left side, it will now appear in its usual location on the _right_ side of the item socketing window. (It was originally intended to not be visible at all if the left setting was used, but that hasn't displayed properly in ages and no one complained, so I guess it probably doesn't cause any problems there.)

### Version 2.1.14

* Fixed a bug introduced in 2.1.13 where the list of scales in the Pawn UI wouldn't show or hide immediately upon switching between Automatic and Manual mode.

### Version 2.1.13

* Scales that are imported with both Class and Spec included will use spec icons and class colors by default, just like the built-in Automatic scales. (Pawn will automatically include them when exporting any of the built-in scales.)
    * Scales you've already imported in previous versions need to be re-imported for this to work.
    * There's currently no way to change a scale's class, spec, or icon in the Pawn UI other than through the export and import features.
* Pawn scale tags can now specify a spec using its English name instead of just a number. For example: ( Pawn: v1: "Hunter: Beast Mastery": Class=Hunter, Spec=BeastMastery, Agility=10 )
    * Scales exported in this version can't be imported into earlier versions of Pawn, so for the next few weeks while people may not have updated, if you share scales with others, you may need to remind them to upgrade. (Or, change Spec= to its old number form: 1 is the first spec listed in the game's Specialization window, 2 is the second, and 3 is the third.)
* When using the "show item IDs" option, Pawn will once again show item IDs for items that can't be equipped (food, relics, crafting reagents, and so on).
* Fixed a bug where the color picker would disappear too soon when choosing a scale color.
    * There's still a bug where the initial color that appears when choosing a new color is incorrect, but that's a problem with the game itself. (For example, you can see the same issue with the chat window color options.)
* Worked around a problem where the item level display that appears when hovering over the Pawn button while inspecting another player would undervalue off-hand artifacts (including weapons, shields, and frill). (The game shows the item level of off-hand artifacts as 750 regardless of their actual level, so Pawn works around the bug by assuming that the off-hand artifact is always the same level as the main-hand artifact.)

### Version 2.1.12

* New updates to the default Ask Mr. Robot scales for patch 7.1.5.

### Version 2.1.11

* Added some new unverified changes that will hopefully eliminate the problem a few people are seeing where items are missing stats and causing other items to show up as upgrades when they aren't.
* Fixed a bug where the Template button on the Scale tab didn't work.
* Made some minor changes that should slightly improve performance with certain items that can never have stats, like artifact relics and tabards.
* Updated all of the default Ask Mr. Robot scales with new stat weights.

### Version 2.1.10

* Additional minor changes to help debug a problem some people are having with items missing stats.

### Version 2.1.9

* Performance enhancements based on suggestions from rowaasr13 of Garrison Mission Manager.
* Pawn's Bag Upgrade Advisor will no longer show green arrows on items in your bags that aren't equippable yet because you don't meet the level requirement. (You'll still see them if you hover over the item.)
* Added support for the comparison tooltips that appear when holding Shift over the point-of-interest icon for a world quest that rewards an equippable item.
* The "compare item left" and "compare item right" keybinds now work on world quest rewards.

### Version 2.1.8

* Updated stat weights from Ask Mr. Robot for changes in patch 7.1 and recent hotfixes.

### Version 2.1.7

* Fixed a mistake I introduced in version 2.1.6 that caused characters to become undying servants of the Lich King if they use Automatic mode (the default), which caused Pawn to not show anything on tooltips, and make it appear as if Pawn thought that your spec was Blood in the Pawn window.

### Version 2.1.6

* Improved performance in raid groups when in Automatic mode (the default).

### Version 2.1.5

* Increased Pawn's memory usage in exchange for faster item scans. (Memory usage should still only be a couple MB, but finding bag upgrades should be much faster.)
* Minor translation updates.

### Version 2.1.4

* Fixed a bug where occasionally Pawn would complain about finding too many "bonus IDs" on items.
* Removed the "ignore valor and baleful upgrades" feature, since those items are not relevant anymore.

### Version 2.1.3

* Updated translations.

### Version 2.1.2

* The Compare tab will no longer show the differential between the sockets and socket value on the left item versus the right item. (For example, if one item has no socket, and the other has a socket worth 1,250 points, it will no longer show "+1,250".) After this change, the green and red numbers shown will always only be stats, which should make them easier for new people to understand.
* Fixed a bug where it was no longer possible to export some scales (generally, scales that were created using the "empty" button or importing, rather than copying an existing scale or starting from a template).

### Version 2.1.1

* Pawn will now take over the new WoW 7.1 feature that puts green arrows on items in your bags. Normally the feature shows you items that are a higher item level than what you have equipped. Pawn will change the feature so that it shows items that are an upgrade to your currently-equipped gear for any of your active scales. (For example, if you're in the default Automatic mode, it'll put upgrade arrows next to items that are better for your current spec, but not for other specs.)
    * This feature has no effect on the WoW 7.0 live realms.
    * If you don't like this, and would rather go back to the old behavior, uncheck "Show bag upgrade advisor" on Pawn's Options tab.

### Version 2.1

* Pawn's default stat weights now come from Ask Mr. Robot! The existing Wowhead placeholder scales have been removed, and the Ask Mr. Robot scales work automatically in the same was as the previous placeholders, but now have more appropriate and helpful advice for each specialization.
    * If you'd like advice for more than one spec at once, switch to Manual mode on the Scales tab, and then you can show and hide additional scales from there.
    * You may notice that items in your bags or bank that weren't upgrades before version 2.1 are now showing up as upgrades—that's to be expected, as some of the new stat weights in this version are vastly different than before.
* In the English version, the Values tab has been renamed to Weights, to better match the generally accepted terminology.
* The item level display on the Compare tab will no longer show the difference between the two levels ("+15" etc.). I'm hoping that this makes it clearer that the item level isn't used in calculations.
* Pawn will no longer add orange diamonds to special effects that it doesn't understand on items. I felt that in modern versions of Pawn, those were just clutter, and didn't really provide useful information.

### Version 2.0.14

* The previous version of Pawn fixed Latin American Spanish while breaking European Spanish. This version should hopefully work for both. (There's a new difference in the way that numbers are displayed between the two versions of WoW that I wasn't aware of previously. Sorry!)

### Version 2.0.13

* Hopefully fixed a problem when Pawn is used in Spanish where stats 1,000 and up would be massively undervalued.
* When choosing between relics as quest rewards, Pawn's Quest Upgrade Advisor will now show the same (?) icon that it does for trinkets, instead of showing you which one to choose to vendor.

### Version 2.0.12

* Pawn's Quest Upgrade Advisor will now also help you identify upgrades rewarded by world quests.

### Version 2.0.11

* Updated the values of Broken Isles gems again after the recent hotfix. _FFS, Blizzard._

### Version 2.0.10

* The "ignore gems while leveling" feature will now ignore sockets on items below ilvl 800.
* Made a small tweak to work around a problem that was reported where an error occurred when trying to sell a battle pet.

### Version 2.0.9

* Updated the values of Broken Isles gems. Pawn will no longer vastly overvalue sockets on Broken Isles gear.

### Version 2.0.8

* Fixes to the French translation.

### Version 2.0.7

* Fixed a problem that could occur on some new items where Pawn would display an error message about not expecting an item with 5 bonus IDs.
* Minor update to the Simplified Chinese translation.

### Version 2.0.6

* Fixed a problem where one-handed weapons could show up as huge upgrades for characters who can't dual-wield. (They were being compared against the character's off-hand frill item or shield.)
* Updated Korean translation.

### Version 2.0.5

* Pawn will now show "your best" and "your second best" on tooltips of equipped rings and dual-wielded weapons when using the default settings.
* When the item on the left side of the Compare tab is better, its upgrade arrow will now be green like all other upgrade arrows in Pawn.

### Version 2.0.4

* By popular demand, the Ignore Valor and Baleful Upgrades option has returned. It's on by default, but you can turn it off to better compare new gear.
    * I'll wait to remove this option until Legion actually launches.
* A few more translation updates for Russian.

### Version 2.0.3

* Made a hopefully-better fix for the problems on the Russian version of WoW.
* Updated translation for Russian.

### Version 2.0.2

* Fixed a bug where one-handed weapons would appear to be upgrades for dual-wielding characters far too often.
* Hopefully fixed a problem where numbers 1,000 and up were being calculated incorrectly in the Russian version of WoW.
* Updated translations for Italian, Korean, Portuguese, Russian, Spanish, Simplified Chinese, and Traditional Chinese.

### Version 2.0.1

* Adjusted the value of gems to account for a difference in the values of Draenor gems on the live version of the patch versus what they had on beta.
* Increased the item level threshold at which Pawn will start suggesting that you use Legion gems so that you shouldn't see that happen on your Mythic Hellfire Citadel gear. _(Looks at own gear and weeps softly)_
* Updated translations for Spanish and Italian.

### Version 2.0

Pawn 2.0 only works on World of Warcraft 7.0, the Legion prepatch.

#### New features and big changes

* By default, Pawn will now automatically make suggestions based on your current spec and nothing else, and it will automatically switch its suggestions whenever you change specs. If you prefer to show multiple specs on your tooltips and customize them, just go to the Scale tab and switch to Manual.
* To keep things simple, when deciding whether a new item is an upgrade, Pawn will now just compare it against what you currently have equipped. This should be more straightforward now that gear works for all specs, and better mimics the way that other RPGs with similar features (like Diablo) work. You can return to the previous Pawn behavior if you prefer by switching to Manual mode on the Scale tab, and then checking "track for each scale" on the Options tab.
* All of the built-in scales have been rebuilt from scratch. For now, the stat values are simplified and are not coming from Wowhead, but I expect to resume getting expert advice from them in the coming weeks.
    * Please report any bugs you find with incorrect item types marked as not being usable, and so on!

#### Other less exciting stuff

* This version now supports all of the languages that Pawn 1.9 supported—special thanks to the Pawn translation volunteers!
    * Not all translations are complete yet, but if you do notice something completely broken, please let me know what, and which language.
* The Pawn UI visuals have now been slightly tainted by the Fel.
* Pawn will now show spec icons on your tooltips (only for default scales), which should make them easier to find and tell apart. You can turn this off on the Options tab.
* Built-in scales that are designed for only your current class will no longer show the class name on item tooltips. For example, "Havoc: +14% upgrade" instead of "Demon Hunter: Havoc: +14% upgrade".
* Pawn's gem database has been fully updated to account for the stat changes in patch 7.0.
* To keep the suggestions manageable, Pawn will no longer consider multi-stat (green, orange, or purple) gems on low-level items.
* The Gems tab has been simplified, and will no longer show each gem three times (under red, yellow, and blue gems).
* The "Defaults" button on the Scale tab has been removed. A new "Template" button has been added, which creates a more useful scale to start from for your current spec.
* Pawn's Socketing Advisor now gives a full list of gems when you have Automatic mode enabled (which is the default).
* Pawn's features for assuming that you'll use Valor and Baleful tokens to upgrade your items have been removed.
* Removed support for Bonus Armor, Spirit, Multistrike, Spell Power, and colored sockets, as those stats have been removed from the game.
* Removed support for meta sockets, PvP Resilience, and PvP Power, as those stats are not relevant on any current gear (though they do still exist in-game, such as on the Dreadful Gladiator sets).
* Dodge and Parry on low-level items and tank heirlooms will now be interpreted as if it were Stamina.
* Attack Power on low-level items will now be interpreted as if it were Strength or Agility, whichever your scale values most.
* I expect that for most players, Pawn's memory usage will decline significantly.

#### Bug fixes and minor tweaks for 7.0

* I improved the "getting started" text that probably nobody reads. Now it'll take even less time for people to not read it.
* The Pawn UI now opens to the Compare tab by default (except the first time you open it).
* Fixed a rare division by zero error that could occur when wearing cosmetic armor with no stats.

### Version 1.9.31

* Partial gem support has been restored on the Legion beta. The new Legion gems will be used in all calculations regardless of the level of the item. It'll probably stay this way until close to the Legion release date.

### Version 1.9.30

* Due to a problem with Pawn's gem calculations interacting poorly with the quest turn-in window (yes, you read that right) on the Legion beta, gem calculations on the Legion beta are temporarily disabled.
    * This doesn't affect characters on the live servers.
    * This will cause items with sockets on the Legion beta to be valued the same as the same item without sockets.

### Version 1.9.29

* Fixed the "Change color" button on the Scales tab on the Legion beta. (Thanks Eduard from Curse! :)

### Version 1.9.28

* Added support for the new Legion gems. (But you can't see them on the live realms.)
* Warglaives will no longer show up as usable for any class except demon hunter.
* More minor tweaks to the basic starting scale for demon hunters.

### Version 1.9.27

* A few quick tweaks to make Pawn work better on the Legion beta realms.
    * There's plenty of stuff yet to do, like removing obsolete stats, and adding support for artifact weapons—that will come soon.
* Added a basic starting scale for demon hunters.

### Version 1.9.26

* Updated Spanish and Simplified Chinese translations.

### Version 1.9.25

* Added support for a few Baleful items that weren't being recognized previously. (If you're really curious, bonus ID 653.)

### Version 1.9.24

* Items in the Heirloom collection window will now get Pawn annotations on their tooltips.
* Fixed a bug introduced in 1.9.23 where, when hovering over the Pawn button on your character sheet while the "show scale values and upgrade %" option was chosen, the total values for all equipped items were not being displayed properly.

### Version 1.9.23

* When Pawn shows you an upgrade percentage for an item that requires Valor and/or an Empowered Apexis Fragment to achieve, it will now show up as "+X% upgrade potential" instead of merely "+X% upgrade". Hopefully this will make it a bit clearer how an ilvl 650 baleful item can be a significant upgrade over an ilvl 670 raid item.
    * This change will only affect English at first, until translations are available.

### Version 1.9.22

* For Baleful items, Pawn will now use the Empowered version of the item (the one that you get with an Empowered Apexis Fragment that's level 695 before valor upgrades) when calculating the base value of an item.
* Added an option to make Pawn no longer assume that you'll use Valor and Empowered Apexis Fragments to upgrade your gear when comparing different items.

### Version 1.9.21

* For items upgradeable with Valor, Pawn will now use the fully-upgraded version of the item when calculating the base value of an item. (The current value of the item, which is not shown on tooltips by default, will still use the current upgrade level.) This means that when comparing (for example) a level 630 item that isn't upgradeable to a level 650 item that is, the upgrade % shown will be about 1.5x what it was previously. Upgrade percentages between two upgradeable (or two non-upgradeable) items will remain roughly the same as before.
* Fixed a problem where tooltips for craftable items did not get Pawn annotations (values and upgrade %).

### Version 1.9.20

* Works around a WoW bug where quest reward items were not getting Pawn information on their tooltips most of the time. (Special thanks to Phanx for helping to track down more patch 6.2 compatibility problems!)

### Version 1.9.19

* Pawn now includes data for the Immaculate Taladite epic gems, and will suggest them for items level 695 and up (Mythic Blackrock Foundry / Heroic Hellfire Citadel).
* Pawn now knows about Khadgar's legendary rings.
* Preparation for translation into Korean.

### Version 1.9.18

* Various diagnostic changes to help me identify the compatibility problems with patch 6.2, and some attempted fixes.

### Version 1.9.17

* A few updates to make Pawn work better on WoW patch 6.2.

### Version 1.9.16

* The "Special effects were not included in the value" message that you'd see at the bottoms of tooltips for trinkets and enchanted weapons has been removed.
* The (?) icon used to indicate special effects on items has been replaced with a small orange diamond (like in Diablo III).
* Support for crystals of fear and sha-touched sockets, cogwheels and cogwheel sockets, and assigning a fixed value to the effect portion of a meta gem (2% chance to restore mana, etc.) have all been removed, as those features are no longer relevant in any current content.

### Version 1.9.15

* Pawn will now work with AtlasLoot again.
* Included some improvements to the Portuguese translation.

### Version 1.9.14

* Fixed a bug where sometimes Pawn would save over custom key bindings set up by certain addons, such as ElvUI.
* Included updates and improvements to the Italian translation.

### Version 1.9.13

* Included a variety of updates and improvements to the French translation.

### Version 1.9.12

* Included the correct version of the French translation (with the changes from 1.9.10, which were accidentally reverted in the 1.9.11 release).

### Version 1.9.11

* Significant changes to the built-in Wowhead scales. (Note that this iteration doesn't include spell power, attack power, or weapon DPS. This is the design of the Wowhead scales, not a problem with Pawn.)
* Lots of further improvements to the Spanish translation.

### Version 1.9.10

* Fixed a problem where weapon speed was not read properly in Spanish.
* Made a few changes to try to make the French version of Pawn understand large numbers (1,000 or greater) better.

### Version 1.9.9

* Given their exorbitant cost, Pawn will no longer suggest Greater Taladite gems on gear lower than item level 685 (mythic Highmaul).
* Fixed the problem where some new Draenor wands caused an error to appear in the chat log and did not have their DPS calculated correctly.
* Attempted to fix a problem in Spanish where numbers greater than 1,000 were not read properly.

### Version 1.9.8

* New scales from Wowhead have been integrated into Pawn, and the starter scales that Pawn previously included have been removed.
* Includes a new Spanish translation, which is still a work-in-progress.
* Fixed a bug where the socketing advisor would always unhelpfully suggest that you put a gem "of any color" into a prismatic socket.
* Fixed a bug where It was difficult or impossible to change the color of a scale, depending on where the Pawn window is situated. (It was difficult if the scale list happened to be behind the color window.)
* Fixed a bug where if you opened your chest of Garrison Resources and the last item you won (it showed up in a "you won!" popup) was an upgrade, the Garrison Resources would also show up as an upgrade. (Hey, maybe you got some Complicated Wood instead of Simple Wood.)
* Removed the code that dealt with Wrathion's Breath of the Black Prince item, which added sockets to certain weapons, but is no longer obtainable by new players and not relevant to current content.

### Version 1.9.7

* Strength, Agility, Intellect, and Stamina can't be marked as "unusable" in custom scales. (Since multiple primary stats are on most armor pieces now, marking those as unusable leads to some confusing and unexpected results.)
* Made a couple small improvements to the French, German, and Traditional Chinese translations.

### Version 1.9.6

* Pawn will now no longer suggest gems for items below level 630 (level 100 heroic dungeon). (This change is particularly noticeable for helms, which had high-value meta sockets at level 90, but not at level 100.)
* Improved the German and Simplified Chinese translations.

### Version 1.9.5

* Additional changes to try to prevent the "UseSpecialQuestItem" error from occurring when clicking items in the objectives list.
* More improvements to the Simplified Chinese and Traditional Chinese translations.

### Version 1.9.4

* Dodge and Parry on low-level items will now be treated as if they were Bonus Armor, at a 2:1 ratio. (40 Parry on an item will be treated as 20 Bonus Armor.)
* Pawn will now once again work with AtlasLoot even when the "Use GameTooltip" AtlasLoot setting is off. (Release versions only, not the latest AtlasLoot beta.)
* The warrior tank starter scale now properly has a value for bonus armor.
* Included lots of improvements to the Traditional Chinese translation.

### Version 1.9.3

* Changed the way that Pawn uses item tooltips, in the hopes that it will prevent issues where the game blocks certain buttons and actions due to "taint."
* Fixed a bug where a few settings wouldn't be saved when logging out, including Pawn's list of your best items used for determining upgrades.
* Included new French translations.

### Version 1.9.2

* Continued changes to the starter scales and translations.

### Version 1.9.1

* Bonus armor is now listed as a separate stat from base armor and can be given a value independently.
* Significantly increased the value of armor and bonus armor in the tank starter scales.
* Fixed a harmless error where a message about #(Item1.UnknownLines) could appear in the chat log when using the Compare tab.
* Fixed a harmless error where a message about being unable to parse the item link could appear in the chat log when hovering over a caged battle pet.

### Version 1.9

* Updated for WoW 6.0 and Warlords of Draenor. Many features have changed in some way as a result of item changes in patch 6.0.
* I updated the visuals for the Pawn UI to be a little more warlordy.
* A new set of starter scales have been added for all classes and specs. You can use these scales as you would the old Wowhead scales, and you can also customize them to your heart's content.
* The Wowhead scales have been disabled since they haven't been updated for patch 6.0 and would do more harm than good.
* The values of Pawn's default scale have changed to be a more appropriate starting point for WoW 6.0.
* New stats are recognized and can be assigned values on the Values tab: Bonus Armor, Multistrike, Versatility, Movement Speed, Leech, Avoidance, Indestructible.
* Obsolete stats (hit, etc.) are removed from your scales upon logging in, and have been removed from the UI.
* All of the new Taladite gems in Warlords of Draenor are now in Pawn's database.
* The changes to stats on pre-Draenor gems in Pawn's database have been taken into account for purposes of gem recommendations. (I anticipate that I'll need to do another update of gem stats before the expansion hits.)
* A new option has been added, on by default: "Ignore sockets on low-level items." When this option is enabled, Pawn will ignore sockets when calculating values of low-level items (currently, any item below level 463), so they won't have inflated values when Pawn determines upgrades.
* Pawn's calculations for item values no longer take reforging potential into account since that feature is gone from the game.
* All code for Pawn's Reforge Advisor feature has been removed.
* Changed the way that information about your best items for purposes of determining upgrades is stored and processed. (I now use item links instead of item IDs, since in Warlords of Draenor, a mythic version of one item and the raid finder version of the same item might have the same ID but a different bonus suffix.)

### Version 1.8.11

* Made a tweak to make Pawn's Quest Advisor work better with ElvUI.
* Updated Russian and German translations.

### Version 1.8.10

* The new Timeless, Flexible, Warforged, and Heroic Warforged items will no longer show a (?) next to those terms.

#### Version 1.8.10a

* Actually including the right file this time so the fix described in the notes works.
* New German translation updates.

#### Version 1.8.10b

* New Russian and Simplified Chinese translation updates.

### Version 1.8.9

* Items that an Eye of the Black Prince can be applied to (Sha-Touched weapons from Heart of Fear and Terrace of Eternal Spring, Level 502 Blacksmithing weapons, and weapons that drop in Throne of Thunder) will be valued assuming that you add the socket to that weapon. Weapons from heroic scenarios and Siege of Orgrimmar will not. (Previously only Sha-Touched weapons were correctly being valued in this way.)
* Made a few adjustments to try to better handle chest armor that is classified as "robes" by the game.
* Minor changes for patch 5.4.

### Version 1.8.8

* Fixed some issues with upgrade displays showing incorrect information for wands.
* Fixed some issues with upgrade displays showing incorrect information for characters that don't save healing gear but still have a healing scale enabled.

### Version 1.8.7

* Pawn will now no longer show any weapons other than daggers as upgrades for assassination rogues when using the default Wowhead scales.
* Fixed a rare bug that could occur with quests such as Returned Sevenfold that include both a choice of rewards and some guaranteed rewards, where Pawn could incorrectly display upgrade symbols that were intended for the guaranteed rewards on the icons for the reward choices.
* Fixed a problem that appears to be new for patch 5.3 where inspecting another player that you're not also targeting would not calculate an average item level for that player's equipment.

### Version 1.8.6

* Adjusted the values of PvP power and PvP resilience on MoP-quality gems to their new (halved) values.
* Added Tense Imperial Amethyst.

### Version 1.8.5

* A few minor changes to work around a rare issue where Pawn would load files in a different order on some machines.

### Version 1.8.4

* Priests will no longer incorrectly see bows, crossbows, and guns as potential upgrades when using the built-in Wowhead scales.

### Version 1.8.3

* Sha-touched items from Heart of Fear and Terrace of Eternal Spring (all difficulties) will now always be valued (for base value) as if you've completed Wrathion's Chapter II questline and can add a prismatic socket to the item.
* Added a Brailian Portuguese translation. Thanks maxmag!
* Includes minor updates to the other translations.
* Fixed a couple minor display issues on the Compare tab when one item had sockets and the other did not.
* Thunderforged and Heroic Thunderforged items on the English PTR will no longer show (?) on their tooltips.

### Version 1.8.2

* Fixed a bug in average item level calculations when inspecting hunters. (Their ranged weapons were only getting counted for half the appropriate level.)
* The Reforging Advisor will now also show up when you right-click an item while talking to an arcane reforger.

### Version 1.8.1

* This version of Pawn now includes French support, thanks to translation volunteers othor and Snuff, and an untested Traditional Chinese translation based on work by BNSSNB.
* Reduced Pawn's memory usage by about 35% (at least on my PC) by optimizing the way translations are loaded. Pawn's memory usage should return to about where it was back when it was for a single language only.
* Corrected a calculation problem where the Ghost Iron Dragonling trinket was undervalued because Pawn suggested Cataclysm cogwheels for it instead of Mists of Pandaria cogwheels. (Thanks durandal42!)
* Fixed a minor problem that could occur when using the Compare tab if you used Pawn in the past (or on another computer), then stopped using it, then sold some of your best items, and then started using it again.

### Version 1.8

* This version of Pawn now works for German and Russian in addition to English. Big thanks to the translation volunteers Sandmahn and mgotovtsev! It also has an untested Simplified Chinese translation based on work by bigbamboo.
* This version also contains a large number of changes to prepare for German, Russian, and more languages in the future.
* Some now-unnecessary information that was being stored in Pawn's SavedVariables file will now be removed when logging out.
* Reorganized the Options tab to make it a bit cleaner. Options for changing the digits of displayed precision for values and for controlling the visibility of (?) icons on tooltips were removed.
* Changed a bunch of bits of text throughout Pawn.
* Worked around a problem that occurred with Pawn annotations showing up on AtlasLoot items twice. (To show Pawn annotations on AtlasLoot items, click Options in AtlasLoot and then check Use GameTooltip.)
* Added support for the Pyrium Weapon Chain and Living Steel Weapon Chain.
* Crystals of Fear will now no longer improperly show (?) on their tooltips.

### Version 1.7.4

* Pawn will now properly show values and/or upgrades for mistweaver monks as intended.

### Version 1.7.3

* Fixed another typo that caused Pawn to show an error when high-level engineers opened the Gems tab and prevented cogwheels from showing up in the list.
* Changed the text "best in slot" to "your best" to make it more clear that those items are not the best items you _could_ get (the more traditional definition of that term), but the best that you currently _have_.

### Version 1.7.2

* Fixed an error that occurred when clicking the "Normalize values (like Wowhead)" checkbox on the Values tab as of Pawn 1.7.

### Version 1.7.1

* Fixed a typo that caused Pawn to show an error when opening the socketing window for an item with a cogwheel socket.

### Version 1.7

* The way that Pawn uses gems and socketed items has changed drastically. Pawn will now take an item's level into account and automatically select gems of an appropriate quality to socket into that item for both the socketing advisor, and also to use in calculating the internal item values for the item. So, an epic from Heart of Fear will have Mists of Pandaria gems suggested for it, and an epic from Naxxramas will have Wrath of the Lich King gems suggested for it, without you having to do anything extra. You can still browse through items of various levels on the Gems tab, but doing so no longer changes any settings and doesn't affect calculations.
    * It is no longer possible to manually set a value for colored sockets, cogwheel sockets, or the stats portion of meta sockets. You can still assign a value to the special effects of meta gems ("3% more damage on crits").
* The Gems tab works a little differently now than it did in previous versions. You can now have it show the best gems overall for a given scale, or you can have it show the recommended gems for an item of a particular level.
    * When clicking the Pawn button that appears on the item socketing window, the Gems tab will now automatically be set up to show you recommended gems for an item of the level you're currently socketing.
    * Since Pawn doesn't understand the special effects of meta gems but those are the most important parts of meta gems, Pawn will no longer attempt to suggest meta gems for you. You should instead use online class guides to select the most appropriate meta gem.
* Sockets appear a little differently on the Compare tab than they did in previous versions. The Compare tab will now show you the total value of all sockets and socket bonuses on an item, including colored sockets (either the correct colors of gems plus the socket bonus or all of your best gem, depending on which strategy maximizes the item's value), meta sockets (including the meta effect bonus), cogwheels, and sha-touched weapons. It will also tell you whether you should go for the socket bonus for a particular item without having to open the socketing advisor (so you can find out on items you don't own).
* Made various other small improvements to the Compare tab to handle items with large numbers of stats and scales with large values, so you don't see things like "(+1234..." when numbers get too big to fit on the screen. Now you'll see "(+12.3k)" instead.
* Added some features to make Pawn work with some item tooltip changes in patch 5.1.
* Added new monk scales from Wowhead and removed the placeholder scales for monks that were provided in earlier versions.
* When using the default settings, Pawn will now show you which of your two rings is better so it's easy to tell which one you should replace with your new one, instead of just saying "This is one of your best items." (This information was already available if you turned on the "Show scale values and upgrade %" option.)
* The "add a blank line before values" option is now on by default because it fits the new item tooltip style in patch 5.1 better. You can turn it back off if you don't like it. I made a few other minor modifications to tooltip formatting.
* Pawn will now show a very clear error message if you try to use the English version of Pawn on a non-English World of Warcraft client.
* Fixed a bug introduced as of WoW 5.0 that prevented item levels from showing up on the Compare tab.
* Made a few changes to the way that Pawn starts up that might help some people who were having random troubles with Pawn not working properly immediately upon logging in.
* Pawn 1.7 introduces a ton of changes to the calculation engine. I ran a variety of tests, but please let me know if you notice any anomalies. (If you report an issue, let me know which item and scale you're seeing it on, and what appears to be wrong.)

### Version 1.6.9

* Updated the Wowhead scales for all classes and specs except monks. There are significant changes included for: Protection warrior, Protection paladin, Beast mastery hunter, Assassination rogue, Combat rogue, Discipline priest, Holy priest, Frost death knight, Unholy death knight, Elemental shaman, Guardian druid.

### Version 1.6.8

* By default, if you have a two-handed weapon equipped, Pawn will now not show one-handed weapons or off-hand frill items as upgrades, and vice-versa. (This is determined solely based on your character's currently equipped weapon.) Enable the "Show upgrades for both 1H and 2H" option on the Options tab to get back the old behavior, where Pawn will try to keep track of your best two-handed weapon, main hand weapon, and off-hand weapon or frill item separately, and show you upgrades for all of them, even if you didn't typically use that type of item.
* Changed the way that Pawn thinks about upgrades compared to heirloom items. Previously if you had an heirloom that scaled from level 1 to 80 that granted an XP bonus, it would never suggest another item as an upgrade to that one until you hit level 81. Now it will immediately start showing upgrades to that item upon hitting level 80, because those items stop granting bonus XP as soon as you hit level 80.
* Made a change for a Spanish translation (in development) due to the fact that the Spanish version of World of Warcraft doesn't use commas in numbers like the English version (12,345) or periods like the German version (12.345)—it displays with neither (12345).

### Version 1.6.7

* Added some placeholder scales for monks so that you can use Pawn as you level your pandas! Once more reliable numbers are available I'll include those, but these should be more than sufficient while leveling.
    * Since they're not from Wowhead, they'll show up in a separate "Placeholder scales" category. This new category will sort at the bottom of the list.
* The Wowhead scales will now never show ranged weapons as upgrades for warriors and rogues, nor melee weapons as upgrades for hunters.
* Fixed another issue that Pawn had with understanding certain Mists of Pandaria items with lots of stats.

### Version 1.6.6

* Fixed a version mismatch issue I introduced with the latest update that caused the Compare tab to not work properly.

### Version 1.6.5

* Fixed a bug where when the Loot Upgrade Advisor is disabled, the group loot / need before greed roll window wouldn't appear.

### Version 1.6.4

* Fixed a nasty calculation bug that occurred on items with more than 999 of a stat (the stat would only get 1/1000th of the correct number of points).
* Fixed a problem where sometimes using LinkWrangler and Pawn at the same time would cause an error to appear when logging in.

### Version 1.6.3

* Reimplemented the Loot Upgrade Advisor for the new group loot roll windows in WoW 5.0. It should be functionally equivalent to the old Loot Upgrade Advisor (green arrows on upgrades, and a yellow popup telling you which scales and items it's an upgrade for).
* Added upgrade arrows to items in the Loot Rolls ("/loot") window and the You Won! window.
* Temporarily altered the Wowhead hunter scales to include Expertise (at the same values as Hit) until Wowhead updates their stat weights for 5.0.
* Fixed a bug where the Socketing Advisor tooltip obscured most of the Socket Gems button.

### Version 1.6.2

* Fixed a bug where weapon damage on heirloom weapons would not get properly recognized and counted (and would spam your chat log with an error).
* Fixed a bug where an error could occur when hovering over certain gemmed relic items.
* Fixed a harmless error that could appear when trying to put a relic or throwing weapon into the slots in the Compare tab. (You just can't let that vendor trash go, can you?)

### Version 1.6.1

* Added support for Pawn values on items in Void Storage.
* The spell penetration stat has been converted into the PvP power stat. Any scales that had spell penetration now have PvP power in its place.
* The IsRelic and IsThrown stats are now gone, with no replacement (since relic items and thrown weapons are now vendor trash).
* The stats list on the Values tab has been reorganized slightly.
* The Pawn window is now jade-colored and includes high-resolution art for those of us with 30" monitors.
* Elite* and Heroic Elite-quality items will no longer show an unnecessary (?) icon in Mists of Pandaria.

### Version 1.6

* Initial compatibility with Mists of Pandaria and World of Warcraft 5.0. Not all features will work properly on WoW 5.0 at this time.
    * No built-in scales are available for monks at this time. If you'd like to test out Pawn on a monk but don't have custom stat values you want to use, you have two options:
        * Make a copy of the stat values for the most similar druid spec: go to the Scales tab, click the appropriate druid spec, click Copy, and give the new scale a name.
        * Start from a set of default stat values: go to the Scales tab, click Defaults, and give the new scale a name.
    * Fixed the issue where Pawn couldn't understand stats on tooltips that were greater than 999 and now display with a comma.
    * Added support for the new, generally shorter names of stats ("critical strike" instead of "critical strike rating", "pvp resilience" instead of "resilience").
    * Fixed an issue where monks would get errors when hovering over armor.
    * The Loot Upgrade Advisor is not functional in WoW 5.0.
* Fixed a bug that was causing Pawn to no longer function properly after preordering Mists of Pandaria.
* Added the new level 90 Mists of Pandaria gems to the Gems tab if you're using Pawn on Mists of Pandaria or the 5.0 PTRs.
* Removed the elemental resistance stats since they're not present on modern gear.
* Removed the distinction between bonus armor and base armor since the last items to feature bonus armor were in Wrath of the Lich King and Mists of Pandaria isn't adding any.
* Added a potential bug fix for some sporadic problems where if some players' addons load in a certain order, Pawn might not get initialized properly.

### Version 1.5.20

* Fixed a rare bug that could occur when showing the Loot Upgrade Advisor when an upgrade drops and your computer didn't have the stats for the previous best item for one of your scales from the server yet.
* Fixed (I believe) a long-standing bug where the same ring could be chosen as both your first and second best item for that slot. (Thanks to WildCard_25 for the investigation!)

### Version 1.5.19

* Non-caster classes will no longer have off-hand frill items suggested as upgrades to their off-hand weapon by default (in the Wowhead scales), even if the secondary stats are better, because this almost certainly just means that they aren't dual-wielding, not that the item is _actually_ useful.
* Fixed a minor issue where conflicts with other addons could sometimes cause an error when trying to calculate the average equipped item level of a player you're inspecting. (Pawn still can't calculate the item level in these cases, but it won't cause an error or display inaccurate information.)
* Updated the default Wowhead stat values for warriors.

### Version 1.5.18

* Fixed a bug in the average item level calculation for Fury warriors who use two two-handed weapons.
* Added Pawn annotations to the tooltips that appear in the "You are not eligible for these items" window that appears when you kill bosses a second time in Raid Finder runs, so you'll know how sad you should be that that axe finally dropped when you can't roll on it.

### Version 1.5.17

* You can now once again see someone's average equipped item level by hovering over the Pawn button on the inspect window. (Your own equipped item level is now in the General section of your stats list, even without Pawn installed.)
* Fixed a long-standing issue where hovering over the Pawn button on the inspect window could display inaccurate (too low) totals and average item levels if the server hadn't sent your computer the stats for one or more of the items the inspected player was wearing yet. (Now you know that when you hover over someone at level 85 and see that their average item level is 145, you know that they really _are_ that much of a n00b and it's not just a miscalculation.)

### Version 1.5.16

* Items found in the Raid Finder versions of the Dragon Soul raid will no longer appear with an unnecessary (?) icon.

### Version 1.5.15

* When you delete a character and then create a new character with the same name but a different class, Pawn will now automatically hide the Wowhead scales from the old class and show the Wowhead scales for the new class.
* Corrected the display of the item you're upgrading in the loot upgrade advisor. (Since 4.2 it would say things like "25% upgrade vs. ff00ff00Your Old Item".)

### Version 1.5.14

* Added in the new epic gems available in WoW patch 4.3. (You can't see them when you're on a 4.2 realm.)
* Corrected a few calculation errors for Guardian's Demonseye, Jagged Dream Emerald, and Lightning Jasper.
* Hid the equipped average item level information from the Pawn tooltip when on WoW 4.3 since that's now available on the character sheet without needing Pawn.

### Version 1.5.13

* Fixed a bug where the value of the stats portion of meta sockets ("Meta: stats") was being drastically overvalued (the "Meta: effect" value was being included as well).
* Fixed a bug where it wasn't possible to manually override a value for prismatic sockets.
* Possibly worked around an error that some people were receiving ("attempt to index field 'UnenchantedStats' (a nil value)") that may have been related to Enchantrix or tekKompare. (I'm not sure because I was never able to reproduce it myself.)

### Version 1.5.12

* Added updated Wowhead scales for all classes and specs, significantly updated for patch 4.2. (For example, the new scales for plate tanks no longer include agility.)

### Version 1.5.11

* Added Pawn tooltip support to the encounter journal loot lists in patch 4.2. (This doesn't add upgrade arrows next to the items yet; the upgrade arrows will be on the tooltips themselves.)
* Removed the unnecessary (?) that appeared on honor and conquest gear next to "Season 9".

### Version 1.5.10

* Fixed a bug where one-handed caster weapons (not main hand weapons; pretty much just Amani Scepter of Rites) would show up as massive upgrades for your off-hand slot even though you couldn't actually put the item there.

### Version 1.5.9

* Items that bind to your Battle.net account will no longer get (?) icons on them.

### Version 1.5.8

* Fixed an issue where Fierce Ember Topaz would be improperly suggested or not suggested for socketing. (Calculations were still correct.)
* Added support for the three new Shadowspirit Diamond cuts that were added in patch 4.0.6.
* Fixed a bug where the Gems tab would not show any gems if you were level 81+ didn't have two primary professions (wtf).

### Version 1.5.7

* Upgrades that are less than half of a percent better than your current gear will no longer be shown as upgrades.
* Fixed an annoying bug in 1.5.6 that was causing some people to get a lot of errors ("attempt to compare number with nil") and was causing upgrade tracking features to not work properly for rings.
* Fixed a bug that would occur when hovering over the Pawn button on your character sheet if your computer hadn't downloaded information about your equipped items yet.
* Fixed an issue with a couple Nightstones being improperly suggested for socketing. (Calculations involving those gems were still correct.)

### Version 1.5.6

* I added back a "Show both current and base values" option since some people just couldn't live without it. _(...you whiners. :)_
* Pawn's now smarter about what it considers as upgrades for heirloom items. Heirloom weapons currently scale from level 1 to 80, so when you're level 1 to 79, Pawn won't consider other weapons to be upgrades, but when you hit level 80 it will start suggesting upgrades again. Heirloom chests currently scale from level 1 to 80 so Pawn will work similarly, but they give an XP boost until you hit level 81, so Pawn won't start suggesting upgrades for your chest until you hit level 81. Once you hit the level cap (85 if you have Cataclysm) then it will ignore heirloom-ness for purposes of tracking upgrades.
* Updated the Wowhead stat weights for all warrior specs, holy and protection paladin, marksman hunter, holy priest, elemental shaman, all mage specs, and balance and resto druid.

### Version 1.5.5

* Added a new per-scale option (on by default) that causes Pawn to never consider armor that your class doesn't specialize in as an upgrade after your character hits level 50. (For example, with the option on, a holy paladin wearing crappy quest green plate that sees the most awesome epic mail healing pants _evar_ will still not see that item as an upgrade since it would break the +5% intellect bonus for wearing only plate.) To change this option, go to the Values tab, choose a scale, scroll down to the list or armor types and click one, and then check the option that appears.
* Added new options to disable each of the Pawn advisors (loot upgrade advisor, quest upgrade advisor, socketing advisor, and reforging advisor) individually.
* Added a new option to no longer color the borders of tooltips for items that are upgrades. (This is useful if you also use TipTac or just really don't like that feature.)
* Added proper support for items with prismatic sockets (which will no longer appear in the UI as red sockets) and cogwheel sockets (which were previously ignored).
* The best cogwheels for each of your scales will now be listed on the Gems tab when you're on an engineer of level 81 or higher.
* Included a bunch of new patch-4.0-friendly scales from Wowhead.
* The "show current item values" and "show base item values" options are now gone. Base values are always shown, and current values are never shown.
    * Update: I added this feature back in version 1.5.6.
* The Pawn UI now closes when you press the Escape key.
* Hovering over the Pawn button on your character sheet will now list both the average item level of your gear as well as the "epic item level" that it did in the past. Pawn's epic item level number factors item rarity into the value; the average item level ignores the rarity of the item and will yield numbers that are more comparable to the ones you see in-game, such as the Looking for Dungeon interface.
* Fixed a bug where the socket values for Wowhead scales that aren't visible on your character's tooltips (such as the ones for other classes) were getting socket values calculated that were far too low.
* Fixed a bug where exported scales didn't include the quality of meta gems to use.
* Fixed a bug where item recipes taught by a profession trainer would have unnecessary (?) annotations.
* Fixed a minor display issue that occurred in the Loot Upgrade Advisor when a massive upgrade dropped in a dungeon run.

### Version 1.5.4

* The Quest Upgrade Advisor will now put a question mark (?) icon on trinkets.
* You can now show and hide scales by shift-clicking on their name in the scale list. (Maybe this will help all those people who can't seem to find the "show scale in tooltips" checkbox...)
* Added support for the dodge rating on the new Cataclysm head enchantment for tanks.
* When you copy a built-in (Wowhead) scale, the built-in scale will now be automatically hidden.
* Fixed a bug where if you right-click an NPC who has a quest with some items you've never seen before and some that you have, Pawn would sometimes display incorrect upgrade/vendor information. (Unfortunately, this happens a lot when leveling.)
* Fixed a bug where some reforged items were getting a few extra points in their values for their reforging potential, which shouldn't happen since you can't reforge an item a second time without restoring the original item first.
* Updated stat weights from Wowhead for some rogue, death knight, and shaman specs have been included.
* Added more detail to the "Show item IDs" option, which isn't too useful to most people.

### Version 1.5.3

* Fixed a nasty bug where sometimes hotkeyed spells and abilities would stop working after using the reforging or item socketing UI.
* The Wowhead scales for rogues will now ignore upgrades for two-handed weapons (which would just be fishing poles).

### Version 1.5.2

* You can now set Pawn to hide upgrades for your one-handed weapon set and your two-handed weapon on a per-scale basis. To change this setting, go to the Values tab, select the scale you want to modify, and then find either a one-handed or two-handed weapon in the list of weapon types, and the new option will appear. (The option will not be visible for weapon types that you cannot equip, such as daggers for paladins.)
    * For example, even though paladin tanks can use two-handed weapons, a two-handed weapon is never an "upgrade" for a paladin tanking set, so you can turn off upgrade notifications for them. Similarly, retribution paladins can use one-handed weapons, but they are never upgrades.
* The amount by which you can increase an item's score through reforging is now shown on the Compare tab as "Reforge potential," and is now automatically added to the score of an item.
    * This is consistent with how Pawn treats empty sockets—the assumption is that if you care about the item you will gem and reforge it properly.
* Added a new stat, "Off-hand frill," which applies to all "held in off hand" caster items, and not off-hand weapons.
* The Compare tab will now also show the percentage increase in the score of the better item in addition to the score difference.
* Cloaks will no longer be counted as cloth items, so scales that have "items with this are unusable" set for cloth armor will now get values for cloaks.
* Fixed a bug where the item link window could have a green border when it shouldn't.
* Fixed an error that could sometimes occur when adding off-hand items to the Compare tab using keyboard shortcuts.
* Low-level items with elemental spell damage ("of Fiery Wrath" and so on) will now be treated as if they had spell power, rather than having a specific unique stat.

### Version 1.5.1

* Added the Reforging Advisor, which suggests the way to modify an item that will maximize its value when you're visiting an Arcane Reforger.
    * Be careful when reforging hit rating and expertise; if you adjust your scales to reduce the value of those stats when you're at or near the cap, Pawn will determine that the item's value would be maximized if you reforged the hit or expertise into something else, which may take you below the cap.
* Cataclysm gem cuts are now available on the Gems tab, including many that weren't available in beta. To update your scales to use the new gems, just select them from the lists on the Gems tab. (This is a per-scale setting.)
* The upgrade annotations on weapons will now show which weapon set (1H or 2H) the item is upgrading so it's more clear that, for example, some random green dagger isn't better than Shadowmourne; it's just better than your skinning knife.
* Prismatic sockets on relic items will now get a proper value. (Pawn will treat them as red sockets, but since there are no socket bonuses, it won't really matter—Pawn will assume that you will socket the best gem of any color when calculating the value.)
* If any of the reward choices for a quest is a trinket, Pawn will now never show the coins (highest vendor price) icon on any item for that quest so you aren't as likely to accidentally take a useless item if there's a nice trinket available.

### Version 1.5

* Pawn now tells you when an item you're looking at is an upgrade to your current best gear for a particular scale.
    * Pawn scans your equipped items and all of your Equipment Manager sets to find your best items for each of your scales.
    * Tooltips of items that are better than the best item of the same type will get an upgrade icon and have an upgrade percentage listed.
        * Trinkets are ignored since they have special effects that Pawn can't value that drastically affect their usefulness.
        * For rings, items that are better than your _second_-best ring will be shown as an upgrade.
        * Items can be an upgrade for multiple scales simultaneously. For example, if you had a "healing throughput" scale and a "healing regen" scale, a nice new healing weapon might be better than your current weapon for both of those scales.
    * You can easily compare items against your current best-in-slot items using new buttons added to the Compare tab.
    * Pawn currently assumes that you'll want to keep a two-hander around as well as two one-handers, so upgrades for either set are handled independently. This can create some odd situations; for example, a shaman with no interest in two-handed weapons at all will see most two-handed weapons as a potential upgrade.
        * If you want to avoid this, you can set the two-handed weapon stats ("Axe: 2H," "Polearm," etc.) to Ignored on the Values tab for your scale(s). You can't make changes to the built-in Wowhead scales directly, so you'd have to make a copy of the scale first, hide the Wowhead one, and then modify your copy. I'll look into ways of making this less stupid in future versions.
    * The new upgrade features can be turned off entirely from the Options tab if you find them annoying.
    * Added the Quest Upgrade Advisor, which adds an arrow icon next to quest rewards that are upgrades for you, or if none of the rewards are good, adds a coins icon next to the reward that will vendor for the most money.
    * Added the Loot Upgrade Advisor, which adds a popup window next to the roll window when an item drops that is an upgrade for you.
* The default behavior has changed so that Pawn only modifies tooltips of items that are upgrades. Existing Pawn users will probably want to change the "Show upgrades on tooltips" option to "Show scale values and upgrade %."
* Fixed a problem that appeared in patch 4.0.3 where haste and resilience rating on items was not being recognized.
* Quest rewards shown on the world map will now have Pawn values shown on them.
* "Currently equipped" tooltips attached to the item link window will now have Pawn values shown on them.
* Added a new "stat" for all off-hand weapons. The Wowhead scales for specs that can't use off-hand weapons have that stat ignored.
* Fixed a bug in Pawn's item score cache that was causing unnecessary slowdowns when Pawn needed to calculate several values at once, such as when hovering over the Pawn button on your character sheet, or when "currently equipped" tooltips are visible.
* Scales can no longer mark the weapon speed "stat" as ignored.
* Updated the Wowhead scales to add a placeholder value for mastery rating.
* Updated the value of spirit in the Wowhead shadow priest scale to the levels of hit rating due to the Twisted Faith talent.

### Version 1.4.1

* Pawn will no longer put a (?) next to "Reforged" on reforged items.
* Spell penetration is once again properly recognized on items.

### Version 1.4

* Pawn will now suggest gems based on the colors and cuts available in patch 4.0.
* The new Cataclysm gem cuts (as well as the old Burning Crusade cuts) are available in Pawn's Gems tab. You can select them using the dropdown lists at the top. (As before, you can choose a different quality of gems for each of your scales.) The Cataclysm cuts are not visible unless on the Cataclysm beta.
* The built-in Wowhead scales have been adjusted somewhat for patch 4.0. Hopefully they should better reflect updated class mechanics in 4.0, but they do not currently match the stat weights on Wowhead exactly. If you have suggestions, please see [this thread on the Wowhead theorycrafting forums](http://cata.wowhead.com/forums&topic=169544&p=2315094).
* Many stats have been removed from items and are thus also removed from Pawn. Your existing scales will be automatically converted to take this into account:
    * The following stats will be removed from scales entirely since they were removed from items: armor penetration, defense rating, block value, block rating, ranged attack power, and all forms of single-school spell damage.
    * If the scale contains a value for MP5 and its value for Spirit is less than half of the scale's value for MP5, Spirit will be raised to that amount. MP5 is removed from scales. MP5 still appears on socket bonuses for a few healer items; those socket bonuses will be considered to have 2 Spirit per 1 MP5 for purposes of calculations.
    * The druid concept of "feral attack power" no longer exists, so the fake Feral AP stat has been removed from Pawn as well. Be sure to add weapon DPS to scales to compensate.
    * The following stats have been removed from scales because they are very rare: Health per 5, raw mana, and raw health. Items or enchantments with these rare stats will be instead considered to have points in base stats (Stamina, Intellect) for purposes of calculations.

### Version 1.3.12

* A bunch of new fixes to make Pawn work on the Cataclysm beta and the 4.0 PTRs. This version also works fine on live realms.
    * Mastery rating now works again.
    * The problem where Pawn would hang after scanning approximately 50 items has been resolved.

### Version 1.3.11

* Fixed an embarrassing typo that caused staves and polearms to not get Pawn values for classes that cannot also use two-handed swords, axes, and maces (everyone but warriors, I guess?).

### Version 1.3.10

* Stats with negative values will no longer be taken into account when normalizing item values. (For example, if a scale is Stamina = 10, Intellect = 5, Spirit = -10, then all values for that scale will be divided by 15, not 5.)
* You can now mark stats as "unusable." Items that have that stat on them will get no value for that scale. For example, a scale for shamans can mark plate as unusable, and then all plate armor will get no value for that scale since shamans can't wear it.
* The built-in scales now take advantage of the unusable stats feature, so unequippable items will not receive values. (Your character's current level is not taken into account for this, so for example low-level shamans and hunters will still get values on mail items even though they can't wear mail until level 40.)
* There are now separate stats for the one-handed and two-handed versions of axes, maces, and swords. Existing scales that had a value for those weapon types will now only have a value for the one-handed version of those weapon types and will need to be updated manually.
* Hopefully fixed the bug that a few people were seeing where they sometimes could not select scales. I finally ran into it myself and tried an on-the-spot fix that worked for me.

### Version 1.3.9

* Improved the appearance of the Pawn UI. It's now no longer translucent, so it should be easier to read the text in certain circumstances.

### Version 1.3.8

* Implemented additional performance enhancements so that Pawn uses even less memory and CPU time. Having the Wowhead scales loaded now increases Pawn's memory and CPU usage by only a negligible amount, so I don't recommend disabling them anymore.
* Added an arrow icon to the best item shown on the Compare tab to make it clearer at a glance and for colorblind people.

### Version 1.3.7

* Fixed a bug where Pawn wouldn't recalculate which gems were best for a scale after chanigng stat values until the next time you logged in.
* Fixed a separate bug where sometimes the display of socket values that were calculated automatically (as opposed to manually set) would not display correctly, even if they were properly calculated.

### Version 1.3.6

* Thanks to some gnomish performance engineering, Pawn now uses about 95% less CPU time during login, which should reduce your login times by a second or two.
* Added a new scale from Wowhead for arms warriors.
* Changed the (*) warning message to be a little clearer, and now it has a new (?) icon. Pawn now calls item properties that it doesn't recognize "special effects."
* Fixed a bug where the item special effect warning message wasn't showing up even when enabled.
* Fixed a bug that might occur after the Wowhead scales (or any scales from a "plugin" of any sort) were disabled by deleting Wowhead.lua.

### Version 1.3.5

* Changed a bunch of text to make it even easier for new users to get started with Pawn.
* The default for new users of Pawn is now to only show the base values of items. If you're already using Pawn and have current item values shown, your settings won't be changed and you'll still see both numbers.
* Rearranged the list of stats on the Values tab so that more common stats are easier to find, and really rare stats like raw health aren't wasting prime screen real estate.
* Added support for items with mastery rating for those of you in the Cataclysm beta. (Untested.)

### Version 1.3.4

* Fixed an issue for patch 3.3.5 that prevented you from linking gems from the Gems tab.

### Version 1.3.3

* Added a very small value for Stamina for Wowhead scales that did not already include Stamina. This will help prevent certain very odd gems from appearing as suggestions in the Gems tab. (For example, some DPS scales did not include values for any blue stat, so the ret pally Gems tab included a gem with Spirit!)
* Fixed a bug where Pawn disabled the Blizzard UI's item comparison tooltip that appears when you hold down the shift key while your mouse is over an item link window.

### Version 1.3.2

* Fixed a bug where the Export button would generate an invalid scale tag for the Wowhead scales. Now you can properly export the Wowhead scales just like your own.

### Version 1.3.1

* Fixed a bug where the Pawn socketing suggestions window would not show the proper name of Wowhead scales.

### Version 1.3

**Important!** After upgrading to Pawn 1.3, your Pawn settings and scales will be upgraded and will no longer be visible in older versions of Pawn. If you need to revert to an older version of Pawn, use the new /pawn backup command to make a backup copy of your scales that you can save in a file on your computer.

* You can now see and edit all of your scales in the Pawn UI, regardless of which character you're currently on. (You'll need to log into each of your characters once first.) Each of your scales can be shown in tooltips for just one or none of your characters (like in previous versions), or you can have a scale show up in the tooltips for multiple different characters.
* All of the stat weight presets from Wowhead are now included with Pawn, so you can immediately start using it without needing to import or create any scales if you don't feel like customizing. The Wowhead scales can't be changed, but if you want to use them as a starting point for your own scales you can copy them and modify the copy.
    * If you have feedback for the Wowhead scales, please see the [Wowhead Theorycrafting forum](http://www.wowhead.com/?forums&board=20).
* The new Scale tab now contains most of the per-scale options (such as whether it shows up on your character's tooltips), as well as the options for importing, exporting, and creating scales. The Values tab (previously the Scales tab) is now a bit simpler.
* The list of scales now appears in a pane to the left of the Pawn UI instead of in a dropdown. The scales that are visible on the current character's tooltips will appear at the top of the list.
* The "Normalize values (like Wowhead)" option can now be set individually for each of your scales for finer control.
* Added a new command **/pawn backup** that you can use to back up all of your custom scales at once as a big mass of scale tags.
* Item levels will now only appear on items in the Compare tab if you also have them enabled for item tooltips in Interface Options.
* If you hold down the Shift key when clicking the Delete button to delete a scale, the scale will now be deleted immediately without requiring confirmation.
* Many bugs were fixed, including several bugs that only existed in pre-release versions of Pawn 1.3 and are not listed here:
    * Fixed a potential error when setting up default Pawn keybindings when using Pawn for the first time for a character, and added a diagnostic message to help determine why the problem is occurring.
    * Fixed a bug where often the first item comparison you performed in the Compare tab wouldn't show item values until you clicked the Swap button or the list of scales.
    * Fixed the error that would occur when trying to put an heirloom item in the Compare tab.
    * Fixed a display issue where scales with colons (':') in their names would appear incorrectly on tooltips if the "align values to right edge of tooltip" option were enabled.
    * Fixed a bug where the scale total values listed when hovering over a Pawn button on someone's character sheet weren't listed in alphabetical order.

### Version 1.2.5

* What used to be called the enchanted value of an item is now the current value, and what used to be called the unenchanted value is now the base value. The word "base" now also appears on tooltips. (No functionality has changed; this is just a terminology change.)
* Fixed the error that occurred when hovering over Brewfest steins.

### Version 1.2.4

* Fixed an error that occurred when hovering over profession recipes.

### Version 1.2.3

* You can now select what quality of gems to use for each of your scales on the Gems tab: uncommon, rare, or epic. Each scale can have a different quality level, so your main spec scale can use epic gems, and your offspec scale can use rare gems.
* By popular request, enchanted values of items now no longer include any points for sockets on the item, since the enchanted value is meant to reflect the current state of the item. This means that before you put gems in an item, the enchanted value of an item will be lower than the unenchanted value.
* Fixed a bug where occasionally items that weren't enchanted would show two equal values, such as "123.4 (123.4)". (This was only a display issue; the values were being calculated properly.)

### Version 1.2.2

* Pawn will now calculate correct socket values if you have the "normalize values (like Wowhead)" option enabled.

### Version 1.2.1

* Fixed the "attempt to perform arithmetic on field '?' (a nil value)" error that some users were experiencing in Pawn 1.2.

### Version 1.2

* **Note:** Upon installation, this version of Pawn will automatically make adjustments to each of your scales' socket values. To avoid this, you can turn off the option for each scale to always correctly match gem colors.
* By default, Pawn will automatically choose the best rare-quality level 80 gem of each color and use the value of that gem when calculating item values. Most people will no longer ever need to manually set values for red, yellow, or blue sockets.
* There's now a new Gems tab in the Pawn UI. This tab shows you the best rare-quality level 80 gems that are available for any of your scales. Never again will you wonder which gems to have cut for that new boss drop.
    * The Gems tab also displays suggested meta gems, but take these with a grain of salt; Pawn ignores the special effects on the gem.
    * The Gems tab only considers rare-quality level 80 gems. I'll add support for epic gems very soon in an upcoming Pawn update.
* Pawn will now add a tooltip to the item socketing window displaying the suggested gems to use when socketing that item for each of your scales. In addition, the window now has a Pawn button that takes you directly to the Gems tab for more details.
* Meta sockets are now covered by two values instead of one: the old "Meta socket" value is now "Meta: stats" and covers the normal stat bonuses from meta gems. The new value is "Meta: effect" and covers the bonus effects from meta gems. Helms with an empty meta socket will get the values from both added to their totals. Helms with a filled meta socket will get the values of Meta: effect and the actual stats on the gem added to their totals. This reflects the fact that stat-for-stat, helms with meta sockets are clearly better than helms without them because of the added effects that meta gems bring.
* Adjusted the value of MP5 in the default scale to correspond with current itemization.
* Removed the Pawn feature to show item levels, as it is now built into the game.
* Fixed the "Could not parse the item link" error that appeared when clicking the links that items such as the Titanium Seal of Dalaran and Worn Troll Dice add to chat.
* Corrected the display of socket bonuses on weapons in the Compare tab.
* (English) Enchant Boots: Greater Vitality now works again.

### Version 1.1.13

* Fixed the "attempt to perform arithmetic on local 'Dps' (a nil value)" issue introduced by 1.1.12 relating to feral attack power calculations.

### Version 1.1.12

* Though it doesn't actually exist as a real weapon stat anymore, druids can once again assign a value to feral attack power instead of weapon DPS if they don't like multiplying by 14.
* Updated Outfitter support to handle newer versions of Outfitter. (If alternate outfit tooltips stop working for you, be sure to download the latest version of Outfitter too.)

### Version 1.1.11

* When "show item levels" is enabled, you can now hover over the Pawn button on your character sheet or an inspected player's character sheet to get an estimate of that player's average item level in epic gear. For example, an epic gear level of 200 means that the player is in full 10-man Naxxramas gear; 213 means that the player is in full 25-man Naxxramas gear.

### Version 1.1.10

* Added support for Pawn values on Outfitter alternate-outfit tooltips.

### Version 1.1.9

* Fixed a bug where scales that used to have a value for colorless sockets back when Pawn included them as a possible stat would show inaccurate values if you had normalization turned on.
* Fixed a bug where armor penetration gems (like Fractured Scarlet Ruby) didn't work in the English version.
* Added support for Titanium Plating and Enchant Weapon: Accuracy.
* Minor updates for colorblind mode in patch 3.1.

### Version 1.1.8

* Removed the feral attack power stat entirely since it no longer exists directly on weapons. (Feral druids should increase their value for weapon DPS accordingly.)
* Added compatibility with the mod tdItemTip.

### Version 1.1.7

* One more potential fix for the error that I worked on in the last version.

### Version 1.1.6

* Fixed an issue where Pawn would in rare situations cause an error when it was loaded for the first time for a character (either a new character, or a character new to Pawn). Whether or not a given person would actually experience this bug is essentially random. This is also reported to have worked around game crashes that a few people were seeing.
* Added support for Enchant Boots: Greater Vitality, and the hit rating effect of Titanium Weapon Chain.

### Version 1.1.5

* Feral druids and death knights rejoice! You can now assign separate values to base armor (on cloth, cloaks, leather, mail, and plate) and bonus armor (on weapons, trinkets, necklaces, rings, and enchantments).
    * Please note that pre-Wrath items that had bonus armor (in green text) will have the full armor value reported as base armor even though some is bonus armor. There is currently no way for mods to tell the difference.
* Updated the default values for the socket stats to more appropriate values, assuming that you would use level 80 blue gems in them. Existing scales will not be changed.
* Support for colorless / prismatic sockets added by blacksmithing has been removed. Since these sockets never appear on items normally, and they are simply an interim stage (you'd never socket an item and then decide not to put a gem in it), I decided it didn't make sense to assign values to them.
* The red text that appears after socketed jewelcrafter-only BoP gems that says that they require jewelcrafting will no longer appear with an asterisk (*).
* Added support for Enchant Boots: Icewalker.
* Worked around a bug that could cause the Compare tab to stop working in certain situations.

### Version 1.1.4

* Fixed a bug where, on the Compare tab, meta sockets would appear under the "socket bonus" heading instead of the "sockets" heading.
* Enchantments that are on enchanters' rings when you are not an enchanter (the ones that appear in red) will no longer appear with asterisks (*).
* Armor penetration rating on new Wrath of the Lich King items will now be interpreted correctly.

### Version 1.1.3

* This is the patch 3.0 version of Pawn, and will not work properly on WoW 2.4.x. The stats Spell damage, Healing, Spell hit rating, Spell crit rating, and Spell haste rating have all been removed. Spell damage and Healing have been replaced with Spell power, and the three Spell combat ratings have been combined into hybrid ratings that work for both casters and non-casters. Pawn will update your scales automatically, but you might want to check the values of those stats to make sure that they are in line with what you'd expect.
* Added stats that allow you to assign different values to different armor types (such as plate, cloth, etc.).

### Version 1.1.2

* Added support for account-bound (gold-quality) items and more new things that appear in WoW 3.0.
* Fixed an error message that could appear when using some item links from sites like Wowhead.
* Armor penetration works once more on WoW 3.0.

### Version 1.1.1

* Fixed Link Wrangler compatibility, which was broken in Pawn 1.1.
* Items that have at least one recognized stat (normally marked with an asterisk) will be marked as such in the Compare tab. (This feature existed in 1.1 betas but did not appear in the final version.)
* Added support for Lake Wintergrasp items and the Scourgestone.

### Version 1.1

* This version of Pawn has been tested on both the live realms and on the Wrath of the Lich King beta, and includes _tons_ of fixes to make Pawn work correctly on Wrath servers, and to support new stats and types of items that appear in the expansion content, including new stats, new gems, encrypted items, colorless sockets, and more.
* Pawn now sports a new tab, Compare, which lets you see two items side-by-side to compare their stats in more detail. Check it out!
    * You can compare any two items in your inventory or a merchant's inventory by dropping them in the slots.
    * If the left slot is empty and you drop an item in the right slot, your currently equipped item will automatically be put in the left slot.
    * In addition to dragging and dropping items, all of the following shortcuts also work:
        * Clicking either of the "currently equipped" shortcut buttons that appear in the lower-left corner once there is an item in the right slot.
        * Hovering over an item in your inventory, another player's inventory, a vendor's inventory, an item link window, AtlasLoot, or other locations, and pressing the "[" or "]" key. (This key binding is customizable in the regular key bindings interface.)
        * You can also right-click item link windows and item icons in loot roll windows to immediately compare the item with your currently equipped item.
* The first time you run Pawn after upgrading to 1.1, Pawn will automatically bind keys to its commands if you aren't using those keys for other things. By default, "P" will open and close the Pawn UI, and "[" and "]" are used for item comparisons. If you later unbind those keys or bind them to other actions, Pawn won't try to rebind them.
* Fixed a bug where Pawn values didn't show up on item link windows if you only had unenchanted numbers visible, not enchanted numbers.
* Fixed a problem where error text would appear in the chat window when hovering over recipes in Ackis Recipe List and possibly other similar mods.
* German users rejoice! When entering stat values you can now use a comma instead of a period as a decimal separator—for example, "0,5" now works in addition to "0.5".
* In this version of Pawn, I've significantly reorganized a lot of the code that reads and annotates item tooltips. This, coupled with other changes in Wrath of the Lich King, is likely to cause some conflicts with other mods. If you run into problems with Pawn, please remember to try to reproduce the same problem with no other item-related mods installed. I still may be able to fix the bug if it turns out that the bug is related to another mod, but I need to know _which_ mod to download and try.

### Version 1.0.4

* Fixed a bug that would prevent Pawn from working properly if one or more of your scales didn't assign a value to the spell damage stat.
* Updated the value of the armor penetration and spell penetration stats in the default Pawn scale to match current itemization. Existing scales are not changed.
* Pawn will no longer try to assign a default value to spell damage (WoW 2.4) if you use a scale that contains only spell power (WoW 3.0).

### Version 1.0.3

* Added an entry in the Interface Options dialog to launch the Pawn UI, in case you hide the Pawn button and forget how to get it back.
* You can now assign a value to the Wrath of the Lich King "spell power" stat to your scales. It uses the same values by default as the "spell power" stat in Pawn 0.7.4, and your existing scales will be assigned a value for the stat automatically. Your scales will still have spell damage and healing stats in them, but they won't be used for anything.
* In Wrath of the Lich King, the stats that currently appear as melee hit rating, melee crit rating, and melee haste will also apply to spells, and the spell hit, crit, and haste rating stats are not used. Existing scales will not be modified at this time.

### Version 1.0.2

* When Armory is installed, added support for showing unenchanted values on the item comparison tooltips that appear when holding down the Alt key.
* Added support for the stat-only components of Surefooted, Cat's Swiftness, and Boar's Speed. (The run speed and snare resistance effects are ignored since there are no Pawn stats for those.)
* Fixed a bug where if you clicked a link for an item that had an icon and then a link for a spell that did not have an icon, the item's icon would not properly disappear.
* Fixed a bug with reading certain items with multiple stats on the same line that was causing problems with the French translation in progress.
* Removed a bunch more asterisks from various items.

### Version 1.0.1

* It's now possible to force Pawn to always calculate an item's value based on the correct color of gems (Pawn 0.8 and older behavior) instead of maximizing the item's value by potentially using the wrong colors and ignoring the socket bonus (Pawn 0.9 and later behavior). To change the option for one of your scales, choose that scale in the UI and then choose one of the colored sockets from the stat list.
* Added support for socket bonuses (and possible future gems) that give melee haste rating.
* Added shaman healing scales based on the popular Elitist Jerks thread to the sample scales document that comes with Pawn.

### Version 1.0

* Restored compatibility with Link Wrangler, which stopped working in Pawn 0.9.
* Added support for showing Pawn values on Link Wrangler's "compare equipped items" tooltips.
* Added support for showing inventory icons next to Link Wrangler tooltips.
* There's now a "getting started" tab to gently remind new users to read the Readme file.
* Takes advantage of new WoW 2.4 functionality to show inventory icons next to item link windows in a few situations where it couldn't before.
* Various other UI and text tweaks.

### Version 0.9

* Pawn is now smarter about the way that it values sockets and socket bonuses, which in some cases will slightly change the values of certain items, both with and without gems.
    * If you've already filled all of the sockets on an item and you don't qualify for the socket bonus, Pawn no longer counts the socket bonus stats, since they're not actually there.
    * If you can get a better value by socketing the wrong colors of gems and ignoring the socket bonus, Pawn will now do that when calculating item values. (When the "Show debug info" option is enabled, Pawn will tell you which color gems it used.)
* Pawn now remembers all of the stats from several of the last items you've viewed so it doesn't have to always recalculate them. This should help your framerate when rapidly hovering over many items in succession, especially when an equip compare mod is also installed.
* You now have to type the word "delete" to confirm that you really want to delete a scale.
* You can now make a copy of an existing scale by clicking the new Copy button.
* There is now an option to hide a specific scale from tooltips without having to delete it (and, most likely, export it and paste it somewhere for safekeeping).
* Pawn will no longer look for stats on quest, spell, and ability links in WoW 2.4.
* Fixed a bunch of UI bugs that occurred when deleting your last scale.
* Pawn no longer adds unnecessary asterisks to Black Temple instance-bound items, such as Naj'entus Spine.
* Added support for Reckless Noble Topaz and other gems with spell haste rating.

### Version 0.8.2

* The Pawn UI now displays the current Pawn version number on the last tab.
* Pawn now supports addons that modify the Inspect window when it is first shown instead of immediately upon login, such as Spyglass.

### Version 0.8.1

* You can now hover over the Pawn button on the inventory window to get a grand total of the enchanted values on all of your equipped items.
* There is now a disabled Pawn button on the inspect window that you can hover over to get totals for all of another player's equipped items.
* Fixed a bug where all on/off options that defaulted to being on (show enchanted values, show unenchanted values, and show tooltip icons) would automatically turn back on after logging out and back in.
* Fixed a bug where sometimes disabling enchanted values would cause unenchanted values to also not be displayed.
* Fixed a bug where the word "Projectile" on stacks of arrows would get an asterisk, and their DPS would not count as ranged DPS.
* Fixed a bug where negative values would not be exported in scale tags. (Negative stat values are most common with weapon speed.)

### Version 0.8

* The Pawn UI now has an Options tab that you can use to set all Pawn options.
* Almost all of the Pawn slash commands are now unnecessary, and have been removed. You can still use /pawn to open the Pawn UI, and /pawn debug is still available as well.
* Tooltips have been added to pretty much everything in the Pawn UI.
* You can use the new calculation option "Normalize values" to divide all of your scale values by the sum of all of the numbers in the scale. This causes Pawn to generate the same sorts of numbers that Lootzor does. (See the appropriate section in the readme file for more details.)
* You can now change the text color for your scales individually from the Pawn UI. You could, for example, make your healing scale show up in white and your DPS scale show up in red.
* You can now bind a key to the Pawn UI. Look under "Pawn" in the standard key bindings list.
* Added support for the Fiery Weapon enchantment; Pawn counts it as 4 dps.
* Fixed a bug where sometimes tooltip icons would not appear for items that had never been in your inventory. (This includes most links in trade chat.)
* Fixed a bug where if you clicked on an item link for an item, and then a tradeskill recipe (such as [Alchemy: Super Mana Potion]), the icon for the previous item would stay since the recipe did not have one.
* Fixed a bug where if you had set custom colors for your scales, scales would no longer always be sorted alphabetically by name on item tooltips.

### Version 0.7.5

* Pawn now shows inventory icons next to item link and item comparison tooltips, so when someone links an item, you can also see its inventory icon. You can turn this feature off with /pawn icons off.
    * This feature works with the built-in WoW functionality, as well as a variety of other tooltip mods: EquipCompare, EQCompare, and MultiTips.
* When /pawn ids on is active, Pawn now displays the item IDs of all applicable enchantments and gems in the tooltip as well. For example, if looking at item 123 with no enchantment and gems 45 and 67 socketed, you would see "Item ID: 123:0:45:67".
* You can now have Pawn align item values (and IDs and levels, if those options are on) along the right side of the tooltip with /pawn align numbers right. Some people may find this easier to read; others may find it more difficult.
* A new category of stats has been added, "weapon types," which is primarily useful for racial abilities and talents.
    * For example, orcs get a passive 5 expertise bonus when using axes. So, you might give a weapon a few bonus points just for being an axe. At level 70, 5 expertise costs 78.8 expertise rating, so you might value "being an axe" as high as 78.8.

### Version 0.7.4

* Pawn plugins for FuBar and Titan Panel are now available as separate downloads. You can get them at [Curse](http://www.curse.com/downloads/details/8214/).
* The old "spell power" stat made sense before patch 2.3, but it was particularly confusing to healers after that patch, so I've removed it, and replaced it with easier-to-understand "spell damage". Now, the healing stat only includes healing, and the spell damage stat only includes spell damage.
    * Now, Light's Justice, which says that it increases healing by 382 and damage by 128, has 382 healing and 128 spell damage, exactly as you'd expect.
    * Pawn will automatically upgrade your existing scales and any scale tags that you import. Please double-check the value of the spell damage stat after importing to make sure that it's what you intended, as in this version Pawn does not read your mind. The upgrade process will give correct results for typical cases (DPS casters who don't care about healing; healers who valued spell power at least as high as healing, as they should have), but may not give the results you expect if you had a strange scale (healing but no spell power).
    * As always, the default Pawn scale has been adjusted to accommodate these changes.
* A new slash command /pawn enchanted has been added to let you turn off the enchanted item values, showing only the unenchanted, unsocketed values for items. (You can also use /pawn enchanted off along with /pawn unenchanted off to temporarily hide all Pawn values.) This option may not be compatible with all of your favorite tooltip mods, but it should work in all cases where you currently get unenchanted item values today, which is most everywhere.
* The Pawn button has a new, unique look, instead of being a regular red WoW button.
* The Pawn button now appears in a more reasonable spot when the character inventory window has been skinned using a mod such as Skinner.
* A new slash command /pawn button has been added to let you move the Pawn button on the inventory window, or hide it completely. (If you hide the button, you'll need to type /pawn to open the Pawn UI, or use the Pawn plugin for FuBar or Titan Panel.)
* Added a new option to the /pawn asterisks slash command, /pawn asterisks no text. Using this option is the same as /pawn asterisks auto, except the "* Pawn gave no value to some stats" warning text is not added to tooltips of items with at least one (*) unrecognized stat.

### Version 0.7.3

* Added a button to the inventory window to show and hide the Pawn configuration UI.
* Pawn now supports Armory and EquipCompare working together with the "/eqc alt" option to show comparisons with your alt's gear instead of your current character's.
* Added support for the unusual items with negative stats, such as Kreeg's Mug, which gives -10 Intellect.
* Added support for Braided Eternium Chain and other non-weapon items with weapon damage as an equip bonus. It shows up as minimum damage and maximum damage, but not DPS—it's not a weapon, so there's no speed, and therefore no DPS.
* Fixed a problem that would frequently show up when using Pawn with CowTip, causing an error message to appear in chat when hovering over an item and then an empty inventory slot.
* Fixed a problem where sometimes an open item link window would not be immediately updated upon making scale changes.
* Minor changes to fix some issues when running a German version of Pawn on the German WoW client.
* Updated the samples scales document with newer versions of Emmerald's feral combat models and ShadowPanther's AEP model, and added scales for Malan's Elitist Jerks EP for shamans.

### Version 0.7.2

* The special weapon DPS stats now work. I had broken them in either 0.7 or 0.7.1. Existing scales will automatically be corrected; you should not need to re-enter values for those stats.

### Version 0.7.1

* If the item link window is open when you make changes to your Pawn scales, it will now be updated immediately, so you can see how your changes will affect the value of the item.
* Added spell hit rating and spell crit rating to the configuration UI. (Oops!)
* Corrected a typo in the description of the melee and ranged crit rating stat.

### Version 0.7

* Pawn now has a configuration UI! To access it, simply type /pawn in the chat box. (To see the help information that used to be available when you typed /pawn, type /pawn help, or click the /pawn commands button in the configuration UI.) You should no longer need to manually edit your SavedVariables files to configure Pawn.
* The configuration UI is now the official way to make all changes to your Pawn scales. Some of the slash commands that existed in earlier versions of Pawn are gone, since they're no longer needed: /pawn list, export, import, delete, rename.
* Eliminated that bug where sometimes unenchanted values would disappear from items after a while. The problem seemed to be most commonly linked to use of the world map, but also could occur after zoning or showing the interface options window.
* Scales now appear in alphabetical order on item tooltips.
* Pawn now works with tekKompare and LootLink.
* Fixed a bug where the value of resilience rating in the default Pawn value scale was 0 instead of 1 as was intended. Scale tags that call resilience rating "Resilience" instead of "ResilienceRating" will now be imported properly.
* The value of ArmorPenetration in the default Pawn value scale is now 0.1, based on the latest information on WoWWiki.
* Includes VgerCore 1.0.1.

### Version 0.6.3

* Added support for items in the guild bank vault.
* In _some_ cases, you can use mods that create fake item tooltips like AtlasLoot and ItemSync along with mods that mangle item tooltips like Rating Buster, and Pawn will now still work. No guarantees that your favorite combination of mods won't break Pawn, but this should help a lot of people out.
* Finally fixed that bug where items with both durability and an Equip: or Use: line that Pawn didn't understand would get asterisks on the wrong lines. (For example, Stalker's Helm of Second Sight has this problem.)
* Added the /pawn space command, which adds a blank space before the item values it adds to tooltips.
* Added a special "stat" called SpeedBaseline. SpeedBaseline isn't an actual item property, but rather a number to be subtracted from weapon speeds before they're multiplied by your scale values. For example, if you're an enhancement shaman who wants to give weapons 1 point for every 0.1 second of speed slower than 2.9, use Speed = 10 (1 / 0.1) and SpeedBaseline = 2.9. Weapons slower than 2.9 would instead lose points at the same rate.
* Adjusted the value of the FeralAp stat in the Pawn default scale from 0.5 to 0.4 so that feral items in 2.3 will have roughly the same values as they did in 2.2 with the old Pawn default scale and so that the Pawn default scale still roughly mimics item budget formulas. I do not necessarily recommend that you change values in your own scales; your items have been buffed, so it makes sense for their values to go up.
* Weapon skill rating stats have been removed from Pawn and the default Pawn scale, as they've been removed from the game in the patch. Existing scales will not be automatically updated to use ExpertiseRating.
* Added Pawn values to gems in the socketing UI.
* Fixed the amount of healing and spell damage received from Teardrop Tourmaline and possibly other gems that previously only gave healing.
* Added support for the new Chaotic Skyfire Diamond.
* Now displays a more readable error message when the embedded mod VgerCore is missing or failed to load.
* Fixed several problems introduced in 2.3:
    * Fixed a problem that appeared in 2.3 due to the new way that set item tooltips look where Pawn was putting asterisks all over the name of the set, the items in the set, and the set bonuses.
    * Fixed a problem that appeared in 2.3 where stats on meta gems weren't always being counted due to requirements now being displayed on gems even when socketed.
    * Fixed a bug that appeared in 2.3 only where certain gems and random item properties would appear very strange, such as "+45 Stamina|cfff1a1a1a", and Pawn would not understand them.

### Version 0.6.2

* Fixed a script error that appeared the first time a recipe was clicked since logging in or resetting your UI.
* Pawn now includes VgerCore 1.0 embedded within the mod; you don't need a separate VgerCore folder in your AddOns folder.

### Version 0.6.1

* Supports the 2.2.x live realms and the 2.3 PTRs. (Healing-to-spell-damage and expertise require 2.3, of course.)
* Support for the healing to spell damage conversion. Items that say that they increase healing by 300 and spell damage by 100 will be reported as Healing = 200, SpellPower = 100. Recall that SpellPower _includes_ healing, thus your scale's value for SpellPower should always be equal to or greater than the value for Healing.
* A new value of .255 was picked for the value of Healing in the default scale, down from .455. With this value, items that had 1/3 of their Healing converted to SpellPower (default value .855) in 2.3 will have the exact same values in 2.3 that they did with the old scale in 2.2 (ignoring rounding errors). Of course, you can and should customize your Pawn scales to fit your needs; generally, healers should _not_ adjust their scales to deal with this change.
* Support for the new ExpertiseRating stat, valued at 1 in the default "Pawn value" scale, same as the existing weapon skill stats. Existing scales will not be adjusted to include this stat. If you haven't customized your scales and want to reset them, use /pawn resetscales.
    * Weapon skill ratings are currently still supported so you can use Pawn 0.6.1 on the live realms too. They'll be removed in a later version.
* Support for many more healing enchantments, inscriptions, spellthread, and so forth.
* Craftable items for which you can learn recipes from trainers will now get Pawn values.

### Version 0.6

* Fixed a problem introduced in beta 1 where Pawn would display an error message in the chat window whenever hovering over a ring with Enchant Ring * Weapon Might.
* Added the ability to customize the colors that your scales will use when printed. For example, you could have your DPS value show up in orange, and your healing value show up in green. This is an advanced feature that probably will never get its own UI or slash command. See the section titled "Changing the color of a scale" for more information.
* Importing a scale tag that has the exact same name as a scale you already have will update the old scale to match the values in the scale tag. All of the values in the old scale will be deleted. (In previous versions, Pawn would just fail and warn you that you can't overwrite an existing scale. There is no longer a warning.)
* Weapon stats have been overhauled! Old scales will work, but now advanced users have a variety of new options for assigning values to weapons.
* New stats: MeleeMinDamage, MeleeMaxDamage, MeleeSpeed, MeleeDps, MainHandMinDamage, MainHandMaxDamage, MainHandSpeed, MainHandDps, OffHandMinDamage, OffHandMaxDamage, OffHandSpeed, OffHandDps, OneHandMinDamage, OneHandMaxDamage, OneHandSpeed, OneHandDps, TwoHandMinDamage, TwoHandMaxDamage, TwoHandSpeed, TwoHandDps, RangedMinDamage, RangedMaxDamage, RangedSpeed, RangedDps. Generally, you'll only use a few of these, and not give values to all of them.
* New stats: MinDamage, MaxDamage, Speed. If you don't care about which slot or weapon type it is, just use MinDamage, MaxDamage, Speed, and/or Dps. Dps is now calculated to full precision (say, 41.333 instead of 41.3) instead of rounded to one decimal place.
* Added support for weapon damage enchantments (Striking and Impact).
* Added support for ranged weapon scopes.
* Fixed a problem where certain items with suffixes would show unusually low unenchanted values (their stats would be read as 0). For example, Chimaerascale Legguards of the Bandit exhibited this problem.
* Added support for Black Morass instance-bound items (beacons).

### Version 0.5.4

* Added support for haste rating and spell haste rating, which were added as passive item bonuses on Black Temple equipment. (Iron Counterweight is also supported.) These two stats (HasteRating, SpellHasteRating) are valued at 1 each on the default Pawn scale; existing Pawn scales won't be affected. Use /pawn resetscales to delete all of your scales and replace them with the default one.
* Added support for armor penetration ("Your attacks ignore X of your opponent's armor"). This stat (ArmorPenetration) is not valued in the default Pawn scale.
* Added support for Karazhan, Stratholme, and Tempest Keep instance-bound items.

### Version 0.5.3

* Added support for the new gold profession recipe links in WoW 2.1. (Pawn won't try to read them or put asterisks all over them.)

### Version 0.5.2

* Added working support for the Savagery weapon enchantment, and untested support for Potency, Soulfrost, and Sunfire.
* Added support for EquipCompare 2.10. (This may break compatibility with older versions of EquipCompare; please use the latest version.)

### Version 0.5.1

* Updated for WoW patch 2.1.
* Added support for Blizzard's new Currently Equipped functionality (shift-hover an item).
* LinkWrangler support.
* Fixed a bug where stats in certain situations (gems with multiple stats on one gem, socket bonuses, etc.) wouldn't get shown in the /pawn debug on output. This did not affect calculation; it was just a debug display error.
* Expanded the amount of information Pawn returns in the debug output.
* Added support for Enchant Boots: Vitality.
* Slightly updated a few of the default "Pawn value" scale's numbers. This will not affect existing scales, even if you haven't changed any of the defaults. If you want to get the new scale, you can wipe out your existing scale(s) with /pawn resetscales.

### Version 0.5

* Requires VgerCore 0.4. (This is included with the mod. Pawn will warn you if you are using an older version of VgerCore.)
* Pawn can now show unenchanted values for items in addition to the regular enchanted values, and this is enabled by default. You can turn it off with /pawn unenchanted off. This feature only works for real tooltips, and not fake tooltips from an item database mod.
* Added an option to control the number of digits of precision Pawn uses to display item values in tooltips. By default this is 1 ("3.1"), but you can set it to any number between 0 ("3") and 4 ("3.1416") with /pawn digits #.
* Corrected the value of frost resistance in the default Pawn scale to 1 (was 4).
* Pawn scale tags now have spaces inside of the parentheses by default. This is to prevent certain scale tags from turning into emoticons when posted to certain forums. (For example, if your scale tag ended in "RedSocket=8)", the 8) would turn into an emoticon on certain forums.) Old and current versions of Pawn will accept the scale with or without the extra spaces.
* Lots of work was done to prepare for Pawn translations into other languages. I may have made a mistake in this conversion and introduced cases where (*) shows up where they didn't before; hopefully not.

### Version 0.4.1

* Added support for gun, bow, and crossbow skill ratings.
* Added support for MultiTips.
* Added support for items that list stats as "Stat +X" instead of "+X Stat", namely the epic gems. Gems that only provided primary stats, such as Seer's Chrysoprase, already worked, but others such as Rune Covered Chrysoprase didn't work until this change.

### Version 0.4

* Added scale tags! Scale tags are chunks of text that you can use to share Pawn scales with friends, guildmates, and others on forums, similar to how you can share talent specs today by passing around a link to the WoW talent calculator. You can copy a scale tag and then post it on your guild forums, and then another player can copy that tag and paste it into their game to automatically add your scale to their copy of Pawn, without logging out of the game or changing files in Notepad. To export a scale tag so you can share it with others, use the /pawn export command. To import someone else's scale tag and add it to your own scales, use the /pawn import command.
* Added new slash commands: /pawn list, export, import, delete, and rename.
* Added support for weapon skill ratings (including unarmed and feral combat). (They have been added to the default Pawn scale, but if you care about weapon skill ratings you must add them to your custom scales manually.)
* Fixed the /pawn resetscales command so that it would delete all of your scales before recreating the default one named Pawn value, as was intended.

### Version 0.3.1

* Hovering over an enchanted Item X immediately after hovering over an unenchanted Item X will now recalculate the values for the second item instead of just displaying the ones for the first item. This should work for all pairs of items that differ only by enchantments and gems.

### Version 0.3

* To read statistics, Pawn now makes a copy of the tooltip and reads from that whenever possible, which allows it to read tooltips that have been mangled by other mods. Examples of mods that do this are Mendeleev and Rating Buster. (Certain mods that use custom tooltips, such as ItemSync, don't support this; Pawn may still conflict with mods that modify those custom tooltips.)

### Version 0.2.2

* ItemSync support, including using ItemSync with AtlasLoot. Pawn will calculate and display values for ItemSync's tooltips.
* EQCompare support. Pawn will calculate and display values for EQCompare's tooltips.
* Item level display should work just about everywhere now, instead of just in certain places. (In previous versions, it worked for inventory items, but not chat item links. Now it works on both.)
* A new option has been added to display the item ID for items you come across, /pawn ids on.
* The default is now to hide the asterisks (*) from items that don't have any values for any of your scales. So, for example, Hearthstone and potions won't display the asterisk. You can change this behavior using /pawn asterisks [ on | auto | off ].

### Version 0.2.1

* Fixed a problem in 0.2 where Pawn wouldn't work if you'd never used version 0.1 before.

### Version 0.2

* EquipCompare support. Pawn will calculate and display values for EquipCompare's tooltips.
* AtlasLoot support. Pawn will calculate and display values for instance drops when Atlas and AtlasLoot are installed.
* Outfitter support. Pawn will no longer conflict with the lines that Outfitter adds to tooltips of items used in one or more gear sets.
* MonkeyQuest support. I haven't actually observed it happening in the past, but this change should prevent MonkeyQuest's item tooltip annotations from affecting Pawn.
* MobInfo-2 support. Pawn will no longer conflict with the drop rate information that MobInfo-2 adds to items. (This problem manifested itself both as unnecessary asterisks added to tooltips, and also as an "attempted to concatenate a nil value" error.)
* Added APIs to create and change Pawn scales while you're still logged in. These will eventually be used to build a configuration UI. If you _really_ want to, you can use them from the chat box to change Pawn scales while logged into the game.
* Included a new file "Sample scales.htm" containing (you guessed it) some sample scales that you can use to get started creating your own. I'll add to this over time.

### Version 0.1

* The first released beta version of Pawn. The code is stable and the remaining bugs are mostly just to-do items. I'll get around to them eventually.
* Not heavily optimized for performance.
* No configuration UI. (Hope you like Notepad!)
